/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.samples.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import org.nanocontainer.nanowar.sample.model.Cheese;
import org.nanocontainer.nanowar.sample.service.CheeseService;

public class ListCheeseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CheeseService service;
    private List cheeses;
    private UIData cheeseList;

    public ListCheeseController(CheeseService service) {
        this.service = service;
    }

    public List getCheeses() {
        if (this.cheeses == null) {
            this.cheeses = new ArrayList(this.service.getCheeses());
        }
        return this.cheeses;
    }

    public int getNumCheeses() {
        return this.cheeses.size();
    }

    public UIData getCheeseList() {
        return this.cheeseList;
    }

    public void setCheeseList(UIData cheeseList) {
        this.cheeseList = cheeseList;
    }

    private String getSelectedCheeseName() {
        Cheese cheese = (Cheese)this.cheeseList.getRowData();
        if (cheese == null) {
            throw new NullPointerException("cheese");
        }
        return cheese.getName();
    }

    public String removeCheese() {
        Cheese tempCheese = new Cheese(this.getSelectedCheeseName(), "");
        Cheese storedCheese = this.service.find(tempCheese);
        if (storedCheese == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Cheese " + tempCheese.getName() + "  Not Found!"));
            return "delete error";
        }
        this.service.remove(storedCheese);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Cheese Removed"));
        return "ok";
    }
}

