/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;

public abstract class WagonTestCase
extends PlexusTestCase {
    protected static String POM = "pom.xml";
    protected Repository localRepository;
    protected Repository testRepository;
    protected String localRepositoryPath;
    protected File sourceFile;
    protected File destFile;
    protected String resource;
    protected File artifactSourceFile;
    protected File artifactDestFile;
    protected ChecksumObserver checksumObserver;

    protected void setUp() throws Exception {
        this.checksumObserver = new ChecksumObserver();
        super.setUp();
    }

    protected abstract String getTestRepositoryUrl() throws IOException;

    protected abstract String getProtocol();

    protected void setupRepositories() throws Exception {
        this.resource = "test-resource";
        this.testRepository = new Repository();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
        this.testRepository.setPermissions(this.getPermissions());
        this.localRepositoryPath = FileTestUtils.createDir("local-repository").getPath();
        this.localRepository = this.createFileRepository("file://" + this.localRepositoryPath);
        this.message("Local repository: " + this.localRepository);
        File f = new File(this.localRepositoryPath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    protected void customizeContext() throws Exception {
        this.getContainer().addContextValue((Object)"test.repository", (Object)this.localRepositoryPath);
    }

    protected void setupWagonTestingFixtures() throws Exception {
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
    }

    protected AuthenticationInfo getAuthInfo() {
        return new AuthenticationInfo();
    }

    protected RepositoryPermissions getPermissions() {
        return new RepositoryPermissions();
    }

    protected Wagon getWagon() throws Exception {
        Wagon wagon = (Wagon)this.lookup(Wagon.ROLE, this.getProtocol());
        Debug debug = new Debug();
        wagon.addSessionListener((SessionListener)debug);
        wagon.addTransferListener((TransferListener)debug);
        return wagon;
    }

    private void message(String message) {
        System.out.println(message);
    }

    public void testWagon() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.fileRoundTripTesting();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectory() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("directory-copy/test-resource-1.txt", this.destFile);
            wagon.get("directory-copy/a/test-resource-2.txt", this.destFile);
            wagon.get("directory-copy/a/b/test-resource-3.txt", this.destFile);
            wagon.get("directory-copy/c/test-resource-4.txt", this.destFile);
            wagon.get("directory-copy/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryDeepDestination() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "deep0/deep1/deep2");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "deep0/deep1/deep2");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("deep0/deep1/deep2/test-resource-1.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/test-resource-2.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/b/test-resource-3.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/c/test-resource-4.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryWhenDirectoryAlreadyExists() throws Exception {
        String dirName = "directory-copy-existing";
        String resourceToCreate = "test-resource-1.txt";
        String[] resources = new String[]{"a/test-resource-2.txt", "a/b/test-resource-3.txt", "c/test-resource-4.txt"};
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy-existing");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.createDirectory(wagon, "test-resource-1.txt", "directory-copy-existing");
            for (int i = 0; i < resources.length; ++i) {
                this.writeTestFile(resources[i]);
            }
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy-existing");
            ArrayList<String> resourceNames = new ArrayList<String>(resources.length + 1);
            resourceNames.add("directory-copy-existing/test-resource-1.txt");
            for (int i = 0; i < resources.length; ++i) {
                resourceNames.add("directory-copy-existing/" + resources[i]);
            }
            this.assertResourcesAreInRemoteSide(wagon, resourceNames);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    protected void createDirectory(Wagon wagon, String resourceToCreate, String dirName) throws Exception {
        this.writeTestFile(resourceToCreate);
        wagon.connect(this.testRepository, this.getAuthInfo());
        wagon.putDirectory(this.sourceFile, dirName);
        wagon.disconnect();
    }

    protected void assertResourcesAreInRemoteSide(Wagon wagon, List resourceNames) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Iterator iter = resourceNames.iterator();
        while (iter.hasNext()) {
            String resourceName = (String)iter.next();
            File destFile = FileTestUtils.createUniqueFile(this.getName(), resourceName);
            destFile.deleteOnExit();
            wagon.get(resourceName, destFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNotExists(Wagon wagon, String resourceName) throws IOException, TransferFailedException, AuthorizationException {
        File tmpFile = File.createTempFile("wagon", null);
        try {
            wagon.get(resourceName, tmpFile);
            Assert.fail((String)("Resource exists: " + resourceName));
        }
        catch (ResourceDoesNotExistException e) {
        }
        finally {
            tmpFile.delete();
        }
    }

    private void writeTestFile(String child) throws IOException {
        File dir = new File(this.sourceFile, child);
        dir.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dir.getAbsolutePath(), (String)child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGet() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        try {
            wagon.get("fubar.txt", this.destFile);
            Assert.fail((String)"File was found when it sohuldn't have been");
        }
        catch (ResourceDoesNotExistException e) {
            Assert.assertTrue((boolean)true);
        }
        finally {
            wagon.removeTransferListener((TransferListener)this.checksumObserver);
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testWagonGetFileList() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        String dirName = "file-list";
        String[] filenames = new String[]{"test-resource.txt", "test-resource-b.txt", "test-resource.pom", "more-resources.dat"};
        for (int i = 0; i < filenames.length; ++i) {
            this.putFile(dirName + "/" + filenames[i], dirName + "/" + filenames[i], filenames[i] + "\n");
        }
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        List list = wagon.getFileList(dirName);
        Assert.assertNotNull((String)"file list should not be null.", (Object)list);
        Assert.assertTrue((String)("file list should contain 4 or more items (actually contains " + list.size() + " elements)."), (list.size() >= 4 ? 1 : 0) != 0);
        for (int i = 0; i < filenames.length; ++i) {
            Assert.assertTrue((String)("Filename '" + filenames[i] + "' should be in list."), (boolean)list.contains(filenames[i]));
        }
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWagonGetFileListWhenDirectoryDoesNotExist() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        String dirName = "file-list-unexisting";
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        try {
            wagon.getFileList(dirName);
            Assert.fail((String)"getFileList on unexisting directory must throw ResourceDoesNotExistException");
        }
        catch (ResourceDoesNotExistException resourceDoesNotExistException) {
        }
        finally {
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testWagonResourceExists() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        this.putFile();
        wagon.connect(this.testRepository, this.getAuthInfo());
        Assert.assertTrue((String)(this.sourceFile.getName() + " does not exist"), (boolean)wagon.resourceExists(this.sourceFile.getName()));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonResourceNotExists() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        Assert.assertFalse((boolean)wagon.resourceExists("a/bad/resource/name/that/should/not/exist.txt"));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    protected void putFile(String resourceName, String testFileName, String content) throws Exception {
        this.message("Putting test artifact: " + resourceName + " into test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.sourceFile = new File(FileTestUtils.getTestOutputDir(), testFileName);
        this.sourceFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)this.sourceFile.getAbsolutePath(), (String)content);
        wagon.put(this.sourceFile, resourceName);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void putFile() throws Exception {
        this.putFile(this.resource, "test-resource", "test-resource.txt\n");
    }

    protected void getFile() throws Exception {
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        wagon.get(this.resource, this.destFile);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void fileRoundTripTesting() throws Exception {
        this.message("File round trip testing ...");
        this.putFile();
        Assert.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        Assert.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        this.checksumObserver = new ChecksumObserver();
        this.getFile();
        Assert.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        Assert.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        String sourceContent = FileUtils.fileRead((File)this.sourceFile);
        String destContent = FileUtils.fileRead((File)this.destFile);
        Assert.assertEquals((String)sourceContent, (String)destContent);
    }

    protected Repository createFileRepository(String url) {
        File path = new File(url.substring(7));
        path.mkdirs();
        Repository repository = new Repository();
        repository.setUrl(url);
        return repository;
    }
}

