/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCheckInConsumer
implements StreamConsumer {
    private static final String SENDING_TOKEN = "Sending        ";
    private static final String ADDING_TOKEN = "Adding         ";
    private static final String TRANSMITTING_TOKEN = "Transmitting file data";
    private static final String COMMITTED_REVISION_TOKEN = "Committed revision";
    private ScmLogger logger;
    private File workingDirectory;
    private List checkedInFiles = new ArrayList();
    private int revision;

    public SvnCheckInConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void consumeLine(String line) {
        void var2_3;
        String file;
        this.logger.debug(line);
        if (line.length() <= 3) {
            this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            return;
        }
        if (line.startsWith(COMMITTED_REVISION_TOKEN)) {
            String revisionString = line.substring(COMMITTED_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(SENDING_TOKEN)) {
            file = line.substring(SENDING_TOKEN.length());
        } else if (line.startsWith(ADDING_TOKEN)) {
            file = line.substring(ADDING_TOKEN.length());
        } else {
            if (line.startsWith(TRANSMITTING_TOKEN)) {
                return;
            }
            this.logger.info("Unknown line: '" + line + "'");
            return;
        }
        if (!new File(this.workingDirectory, (String)var2_3).isFile()) {
            return;
        }
        this.checkedInFiles.add(new ScmFile((String)var2_3, ScmFileStatus.CHECKED_IN));
    }

    public List getCheckedInFiles() {
        return this.checkedInFiles;
    }

    public int getRevision() {
        return this.revision;
    }

    private int parseInt(String revisionString) {
        try {
            return Integer.parseInt(revisionString);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }
}

