/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.add;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.add.ClearCaseAddConsumer;
import org.apache.maven.scm.provider.clearcase.command.edit.ClearCaseEditCommand;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseAddCommand
extends AbstractAddCommand
implements ClearCaseCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, String string, boolean b) throws ScmException {
        int exitCode;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing add command...");
        }
        Commandline cl = ClearCaseAddCommand.createCommandLine(scmFileSet);
        ClearCaseAddConsumer consumer = new ClearCaseAddConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            Commandline checkoutCurrentDirCommandLine = ClearCaseEditCommand.createCheckoutCurrentDirCommandLine(scmFileSet);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing: " + checkoutCurrentDirCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + checkoutCurrentDirCommandLine.toString());
            }
            if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)checkoutCurrentDirCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr)) == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr)) == 0) {
                    Commandline checkinCurrentDirCommandLine = ClearCaseEditCommand.createCheckinCurrentDirCommandLine(scmFileSet);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Executing: " + checkinCurrentDirCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + checkinCurrentDirCommandLine.toString());
                    }
                    exitCode = CommandLineUtils.executeCommandLine((Commandline)checkinCurrentDirCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr);
                }
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new StatusScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new StatusScmResult(cl.toString(), consumer.getAddedFiles());
    }

    public static Commandline createCommandLine(ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArg().setValue("mkelem");
        command.createArg().setValue("-c");
        command.createArg().setValue("new file");
        command.createArg().setValue("-nco");
        File[] files = scmFileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            command.createArg().setValue(file.getName());
        }
        return command;
    }
}

