/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.proxy;

import de.saumya.mojo.proxy.ControllerService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ControllerServlet
extends HttpServlet {
    private static final long serialVersionUID = -1377408089637782007L;
    private ControllerService controller;

    public void init() throws ServletException {
        super.init();
        this.controller = (ControllerService)this.getServletContext().getAttribute(ControllerService.class.getName());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] parts = req.getPathInfo().substring(1).split("/");
        try {
            switch (parts.length) {
                case 4: {
                    if (parts[3].equals("maven-metadata.xml")) {
                        resp.setContentType("application/xml");
                        resp.setCharacterEncoding("utf-8");
                        resp.setHeader("Vary", "Accept");
                        this.controller.writeMetaData(parts[2], (Writer)resp.getWriter(), "prereleases".equals(parts[0]));
                        break;
                    }
                    if (parts[3].equals("maven-metadata.xml.sha1")) {
                        resp.setContentType("text/plain");
                        resp.setCharacterEncoding("ASCII");
                        this.controller.writeMetaDataSHA1(parts[2], (Writer)resp.getWriter(), "prereleases".equals(parts[0]));
                        break;
                    }
                    this.notFound(resp);
                    break;
                }
                case 5: {
                    if (parts[4].endsWith(".gem")) {
                        resp.sendRedirect(this.controller.getGemLocation(parts[2], parts[3]));
                        break;
                    }
                    if (parts[4].endsWith(".gem.sha1")) {
                        resp.setContentType("text/plain");
                        resp.setCharacterEncoding("ASCII");
                        this.controller.writeGemSHA1(parts[2], parts[3], (Writer)resp.getWriter());
                        break;
                    }
                    if (parts[4].endsWith(".pom")) {
                        resp.setContentType("application/xml");
                        resp.setCharacterEncoding("UTF-8");
                        this.controller.writePom(parts[2], parts[3], (Writer)resp.getWriter());
                        break;
                    }
                    if (parts[4].endsWith(".pom.sha1")) {
                        resp.setContentType("text/plain");
                        resp.setCharacterEncoding("ASCII");
                        this.controller.writePomSHA1(parts[2], parts[3], (Writer)resp.getWriter());
                        break;
                    }
                    this.notFound(resp);
                    break;
                }
                default: {
                    this.notFound(resp);
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            this.notFound(resp);
        }
    }

    private void notFound(HttpServletResponse resp) throws IOException {
        resp.sendError(404);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }
}

