/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.proxy;

import de.saumya.mojo.ruby.GemScriptingContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jruby.embed.ScriptingContainer;

class ControllerService {
    private final Object rubyObject;
    private final ScriptingContainer scriptingContainer;
    private long blockUpdatesUntil = 0L;
    private final Object mutex = new Object();

    ControllerService(GemScriptingContainer scripting) throws IOException {
        this.rubyObject = scripting.runScriptletFromClassloader("gem_artifacts.rb");
        this.scriptingContainer = scripting;
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update() {
        boolean update = false;
        Object object = this.mutex;
        synchronized (object) {
            if (this.blockUpdatesUntil < System.currentTimeMillis()) {
                this.blockUpdatesUntil = System.currentTimeMillis() + 43200000L;
                update = true;
            }
        }
        if (update) {
            this.scriptingContainer.callMethod(this.rubyObject, "update", Object.class);
        }
        return update;
    }

    String getGemLocation(String name, String version) throws FileNotFoundException {
        String uri = (String)this.scriptingContainer.callMethod(this.rubyObject, "gem_location", (Object[])new String[]{name, version}, String.class);
        if (uri == null) {
            throw new FileNotFoundException();
        }
        return uri;
    }

    void spec2Pom(File specFile, File pomFile) {
        this.scriptingContainer.callMethod(this.rubyObject, "spec_to_pom", (Object[])new String[]{specFile.getAbsolutePath(), pomFile.getAbsolutePath()}, Object.class);
    }

    void writePom(String name, String version, Writer writer) throws IOException {
        String file = (String)this.scriptingContainer.callMethod(this.rubyObject, "to_pom", (Object[])new String[]{name, version}, String.class);
        this.writeout(writer, file);
    }

    void writePomSHA1(String name, String version, Writer writer) throws IOException {
        String file = (String)this.scriptingContainer.callMethod(this.rubyObject, "pom_sha1_file", (Object[])new String[]{name, version}, String.class);
        this.writeout(writer, file);
    }

    void writeGemSHA1(String name, String version, Writer writer) throws IOException {
        String file = (String)this.scriptingContainer.callMethod(this.rubyObject, "gem_sha1_file", (Object[])new String[]{name, version}, String.class);
        this.writeout(writer, file);
    }

    void writeMetaData(String name, Writer writer, boolean prereleases) throws IOException {
        String file = (String)this.scriptingContainer.callMethod(this.rubyObject, "metadata", new Object[]{name, prereleases}, String.class);
        this.writeout(writer, file);
    }

    void writeMetaDataSHA1(String name, Writer writer, boolean prereleases) throws IOException {
        String file = (String)this.scriptingContainer.callMethod(this.rubyObject, "metadata_sha1_file", new Object[]{name, prereleases}, String.class);
        this.writeout(writer, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeout(Writer writer, String file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new FileNotFoundException();
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            int c = ((Reader)in).read();
            while (c != -1) {
                writer.write(c);
                c = ((Reader)in).read();
            }
        }
        finally {
            ((Reader)in).close();
        }
    }
}

