/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import org.apache.commons.collections.primitives.ArrayCharList;

public class CharStack {
    private ArrayCharList list = new ArrayCharList();

    public CharStack() {
    }

    public CharStack(char[] chars) {
        for (int ii = 0; ii < chars.length; ++ii) {
            this.list.add(chars[ii]);
        }
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public char peek() {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.get(this.list.size() - 1);
    }

    public char peek(int n) {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.get(this.list.size() - n - 1);
    }

    public char pop() {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.removeElementAt(this.list.size() - 1);
    }

    public char push(char item) {
        this.list.add(item);
        return item;
    }

    public int search(char item) {
        for (int ii = this.list.size() - 1; ii >= 0; --ii) {
            if (this.list.get(ii) != item) continue;
            return this.list.size() - ii;
        }
        return -1;
    }

    public char get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }
}

