/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.RandomAccessFloatList;

public class ArrayFloatList
extends RandomAccessFloatList
implements FloatList,
Serializable {
    private transient float[] _data = null;
    private int _size = 0;

    public ArrayFloatList() {
        this(8);
    }

    public ArrayFloatList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new float[initialCapacity];
        this._size = 0;
    }

    public ArrayFloatList(FloatCollection that) {
        this(that.size());
        this.addAll(that);
    }

    public float get(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public int size() {
        return this._size;
    }

    public float removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        float oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public float set(int index, float element) {
        this.checkRange(index);
        this.incrModCount();
        float oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public void add(int index, float element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            float[] olddata = this._data;
            this._data = new float[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            float[] olddata = this._data;
            this._data = new float[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeFloat(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new float[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readFloat();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

