/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.UnsupportedEncodingException;
import org.openide.modules.PatchedPublic;

public final class PatchByteCode {
    private static final byte[] RUNTIME_INVISIBLE_ANNOTATIONS;
    private static final byte[] PATCHED_PUBLIC;

    public static byte[] patch(byte[] data) {
        int constant_pool_count = PatchByteCode.u2(data, 8);
        int[] constantPoolOffsets = new int[constant_pool_count];
        int pos = 10;
        block6: for (int i = 1; i < constant_pool_count; ++i) {
            int tag = PatchByteCode.u1(data, pos++);
            constantPoolOffsets[i] = pos;
            switch (tag) {
                case 1: {
                    int len = PatchByteCode.u2(data, pos);
                    pos += len + 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    pos += 4;
                    continue block6;
                }
                case 7: 
                case 8: {
                    pos += 2;
                    continue block6;
                }
                case 5: 
                case 6: {
                    pos += 8;
                    ++i;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("illegal constant pool tag " + tag + " at index " + i + " out of " + constant_pool_count);
                }
            }
        }
        int interfaces_count = PatchByteCode.u2(data, pos += 6);
        pos += 2;
        int fields_count = PatchByteCode.u2(data, pos += 2 * interfaces_count);
        pos += 2;
        for (int i = 0; i < fields_count; ++i) {
            int attributes_count = PatchByteCode.u2(data, pos += 6);
            pos += 2;
            for (int j = 0; j < attributes_count; ++j) {
                int attribute_length = PatchByteCode.u4(data, pos += 2);
                pos += 4;
                pos += attribute_length;
            }
        }
        int methods_count = PatchByteCode.u2(data, pos);
        pos += 2;
        for (int i = 0; i < methods_count; ++i) {
            int locationOfAccessFlags = pos;
            int attributes_count = PatchByteCode.u2(data, pos += 6);
            pos += 2;
            for (int j = 0; j < attributes_count; ++j) {
                int locationOfAttributeName = constantPoolOffsets[PatchByteCode.u2(data, pos)];
                int attribute_length = PatchByteCode.u4(data, pos += 2);
                pos += 4;
                if (PatchByteCode.utf8Matches(data, locationOfAttributeName, RUNTIME_INVISIBLE_ANNOTATIONS)) {
                    int num_annotations = PatchByteCode.u2(data, pos);
                    int pos2 = pos + 2;
                    for (int k = 0; k < num_annotations; ++k) {
                        if (!PatchByteCode.utf8Matches(data, constantPoolOffsets[PatchByteCode.u2(data, pos2)], PATCHED_PUBLIC)) continue;
                        int n = locationOfAccessFlags + 1;
                        data[n] = (byte)(data[n] & 0xF9);
                        int n2 = locationOfAccessFlags + 1;
                        data[n2] = (byte)(data[n2] | 1);
                    }
                }
                pos += attribute_length;
            }
        }
        return data;
    }

    private static int u1(byte[] data, int off) {
        int b = data[off];
        return b >= 0 ? b : b + 256;
    }

    private static int u2(byte[] data, int off) {
        return (PatchByteCode.u1(data, off) << 8) + PatchByteCode.u1(data, off + 1);
    }

    private static int u4(byte[] data, int off) {
        return (PatchByteCode.u2(data, off) << 16) + PatchByteCode.u2(data, off + 2);
    }

    private static boolean utf8Matches(byte[] data, int off, byte[] expected) {
        if (PatchByteCode.u2(data, off) != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (data[off + 2 + i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations".getBytes("UTF-8");
            PATCHED_PUBLIC = ("L" + PatchedPublic.class.getName().replace('.', '/') + ";").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

