/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NetigsoFramework;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

final class NetigsoModule
extends Module {
    static final Logger LOG = Logger.getLogger(NetigsoModule.class.getPackage().getName());
    private final File jar;
    private final Manifest manifest;
    private int startLevel = -1;

    public NetigsoModule(Manifest mani, File jar, ModuleManager mgr, Events ev, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        super(mgr, ev, history, reloadable, autoload, eager);
        this.jar = jar;
        this.manifest = mani;
        this.computeProvides(mani.getMainAttributes(), false);
    }

    @Override
    public String getCodeName() {
        return this.getCodeNameBase();
    }

    @Override
    public String getCodeNameBase() {
        String version = this.getMainAttribute("Bundle-SymbolicName");
        return version.replace('-', '_');
    }

    @Override
    public int getCodeNameRelease() {
        String version = this.getMainAttribute("Bundle-SymbolicName");
        int slash = version.lastIndexOf(47);
        if (slash != -1) {
            return Integer.parseInt(version.substring(slash + 1));
        }
        return -1;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        String version = this.getMainAttribute("Bundle-Version");
        if (version == null) {
            LOG.log(Level.WARNING, "No Bundle-Version for {0}", this.jar);
            return new SpecificationVersion("0.0");
        }
        int pos = -1;
        for (int i = 0; i < 3; ++i) {
            if ((pos = version.indexOf(46, pos + 1)) != -1) continue;
            return new SpecificationVersion(version);
        }
        return new SpecificationVersion(version.substring(0, pos));
    }

    public String getImplementationVersion() {
        String explicit = super.getImplementationVersion();
        return explicit != null ? explicit : this.getMainAttribute("Bundle-Version");
    }

    @Override
    protected void parseManifest() throws InvalidException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    @Override
    public List<File> getAllJars() {
        return Collections.singletonList(this.jar);
    }

    @Override
    public void setReloadable(boolean r) {
        this.reloadable = true;
    }

    @Override
    public void reload() throws IOException {
        NetigsoFramework.getDefault().reload(this);
    }

    final void start() throws IOException {
        ProxyClassLoader pcl = (ProxyClassLoader)this.classloader;
        Set<String> pkgs = NetigsoFramework.getDefault().createLoader(this, pcl, this.jar);
        pcl.addCoveredPackages(pkgs);
    }

    @Override
    protected void classLoaderUp(Set<Module> parents) throws IOException {
        assert (this.classloader == null);
        this.classloader = new DelegateCL();
        NetigsoFramework.classLoaderUp(this);
    }

    @Override
    protected void classLoaderDown() {
        LOG.log(Level.FINE, "classLoaderDown {0}", this.getCodeNameBase());
        ProxyClassLoader pcl = (ProxyClassLoader)this.classloader;
        ClassLoader l = pcl.firstParent();
        if (l == null) {
            NetigsoFramework.classLoaderDown(this);
            return;
        }
        NetigsoFramework.getDefault().stopLoader(this, l);
        this.classloader = null;
    }

    @Override
    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (this.classloader == null) {
            try {
                this.classLoaderUp(null);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.classloader == null) {
            throw new IllegalArgumentException("No classloader for " + this.getCodeNameBase());
        }
        return this.classloader;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    public Object getLocalizedAttribute(String attr) {
        return null;
    }

    @Override
    public String toString() {
        return "Netigso: " + this.jar;
    }

    private String getMainAttribute(String attr) {
        String s = this.manifest.getMainAttributes().getValue(attr);
        if (s == null) {
            return null;
        }
        return s.replaceFirst(";.*$", "");
    }

    @Override
    final int getStartLevelImpl() {
        return this.startLevel;
    }

    final void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    private final class DelegateCL
    extends ProxyClassLoader
    implements Util.ModuleProvider {
        public DelegateCL() {
            super(new ClassLoader[0], false);
        }

        private ProxyClassLoader delegate() {
            ClassLoader l = this.firstParent();
            assert (l != null);
            return (ProxyClassLoader)l;
        }

        @Override
        public URL findResource(String name) {
            return this.delegate().findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate().findResources(name);
        }

        @Override
        protected Class<?> doLoadClass(String pkg, String name) {
            return this.delegate().doLoadClass(pkg, name);
        }

        @Override
        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.delegate().loadClass(name, resolve);
        }

        public String toString() {
            ClassLoader l = this.firstParent();
            return l == null ? "Netigso[uninitialized]" : "Netigso[" + l.toString() + "]";
        }

        @Override
        public Module getModule() {
            return NetigsoModule.this;
        }
    }
}

