/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.FileUtils;
import org.mule.util.SerializationUtils;
import org.mule.util.UUID;
import org.mule.util.queue.QueueKey;
import org.mule.util.store.AbstractObjectStoreContractTestCase;
import org.mule.util.store.QueuePersistenceObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuePersistenceObjectStoreTestCase
extends AbstractObjectStoreContractTestCase {
    private static final String QUEUE_NAME = "the-queue";
    private TemporaryFolder tempFolder;
    private File persistenceFolder;
    private MuleContext mockMuleContext;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.initTemporaryFolder();
        this.initMockMuleContext();
    }

    private void initTemporaryFolder() throws IOException {
        this.tempFolder = new TemporaryFolder();
        this.tempFolder.create();
    }

    private void initMockMuleContext() {
        this.persistenceFolder = this.tempFolder.newFolder("persistence");
        MuleConfiguration mockConfig = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)mockConfig.getWorkingDirectory()).thenReturn((Object)this.persistenceFolder.getAbsolutePath());
        this.mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.mockMuleContext.getConfiguration()).thenReturn((Object)mockConfig);
        Mockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
    }

    @Override
    protected void doTearDown() throws Exception {
        this.tempFolder.delete();
        super.doTearDown();
    }

    public QueuePersistenceObjectStore<Serializable> getObjectStore() throws ObjectStoreException {
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(this.mockMuleContext);
        store.open();
        return store;
    }

    @Override
    public Serializable getStorableValue() {
        return new DefaultMuleMessage((Object)"Test Message", muleContext);
    }

    @Override
    protected Serializable createKey() {
        return new QueueKey("theQueue", (Serializable)((Object)UUID.getUUID()));
    }

    public void testCreatingTheObjectStoreThrowsMuleRuntimeException() {
        MuleRuntimeException muleRuntimeException = new MuleRuntimeException(CoreMessages.createStaticMessage((String)"boom"));
        MuleContext mockContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)mockContext.getConfiguration()).thenThrow(new Throwable[]{muleRuntimeException});
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(mockContext);
        try {
            store.open();
            QueuePersistenceObjectStoreTestCase.fail();
        }
        catch (ObjectStoreException ose) {
            // empty catch block
        }
    }

    public void testAllKeysOnNotYetOpenedStore() throws ObjectStoreException {
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(this.mockMuleContext);
        List allKeys = store.allKeys();
        QueuePersistenceObjectStoreTestCase.assertEquals((int)0, (int)allKeys.size());
    }

    public void testListExistingFiles() throws Exception {
        String id = UUID.getUUID();
        File storeFile = this.createStoreFile(id);
        FileUtils.touch((File)storeFile);
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        List allKeys = store.allKeys();
        QueuePersistenceObjectStoreTestCase.assertEquals((int)1, (int)allKeys.size());
        QueueKey key = (QueueKey)allKeys.get(0);
        QueuePersistenceObjectStoreTestCase.assertEquals((Object)id, (Object)key.id);
    }

    public void testRetrieveFileFromDisk() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        this.createAndPopulateStoreFile(id, "Test Message");
        QueueKey key = new QueueKey(QUEUE_NAME, (Serializable)((Object)id));
        Serializable value = store.retrieve((Serializable)key);
        QueuePersistenceObjectStoreTestCase.assertEquals((Object)"Test Message", (Object)value);
    }

    public void testRemove() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        File storeFile = this.createAndPopulateStoreFile(id, "Test Message");
        QueueKey key = new QueueKey(QUEUE_NAME, (Serializable)((Object)id));
        store.remove((Serializable)key);
        QueuePersistenceObjectStoreTestCase.assertFalse((boolean)storeFile.exists());
    }

    private File createAndPopulateStoreFile(String id, String payload) throws IOException {
        File storeFile = this.createStoreFile(id);
        storeFile.getParentFile().mkdir();
        FileOutputStream fos = new FileOutputStream(storeFile);
        SerializationUtils.serialize((Serializable)((Object)payload), (OutputStream)fos);
        return storeFile;
    }

    private File createStoreFile(String id) {
        String path = String.format("%1s/%2s/%3s/%4s.msg", this.persistenceFolder.getAbsolutePath(), "queuestore", QUEUE_NAME, id);
        return FileUtils.newFile((String)path);
    }
}

