/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreNotAvaliableException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.AbstractMonitoredObjectStore;

public class MonitoredObjectStoreTestCase
extends AbstractMuleTestCase {
    private static final int EXPIRATION_INTERVAL = 500;

    public void testShutdownWithHangingExpireThread() throws Exception {
        ExpiringStore store = this.createExpiringStore();
        Thread.sleep(1000L);
        store.dispose();
        MonitoredObjectStoreTestCase.assertTrue((boolean)store.expireStarted);
        MonitoredObjectStoreTestCase.assertFalse((boolean)store.expireFinished);
    }

    private ExpiringStore createExpiringStore() throws InitialisationException {
        ExpiringStore store = new ExpiringStore();
        store.setExpirationInterval(500);
        store.initialise();
        return store;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpiringStore
    extends AbstractMonitoredObjectStore<String> {
        protected boolean expireStarted = false;
        protected boolean expireFinished = false;

        protected void expire() {
            try {
                this.expireStarted = true;
                Thread.sleep(5000L);
                this.expireFinished = true;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("expire was interrupted", e);
            }
        }

        public boolean contains(Serializable id) throws ObjectStoreNotAvaliableException {
            return false;
        }

        public String remove(Serializable id) throws ObjectStoreException {
            return null;
        }

        public String retrieve(Serializable id) throws ObjectStoreException {
            return null;
        }

        public void store(Serializable id, String item) throws ObjectStoreException {
        }

        public boolean isPersistent() {
            return false;
        }
    }
}

