/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.Serializable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class InMemoryStoreTestCase
extends AbstractMuleTestCase {
    private InMemoryObjectStore<String> store = null;

    protected void doTearDown() throws Exception {
        this.store.dispose();
        super.doTearDown();
    }

    public void testSimpleTimedExpiry() throws Exception {
        int entryTTL = 3000;
        this.createTimedObjectStore(entryTTL);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("1", "2", "3");
        Thread.sleep(entryTTL + 1000);
        this.assertObjectsExpired("1", "2", "3");
    }

    public void testComplexTimedExpiry() throws Exception {
        int entryTTL = 3000;
        this.createTimedObjectStore(entryTTL);
        this.storeObjects("1");
        Thread.sleep(entryTTL / 2);
        this.storeObjects("2");
        Thread.sleep(entryTTL / 2 + 500);
        this.assertObjectsExpired("1");
        this.assertObjectsInStore("2");
    }

    public void testStoreAndRetrieve() throws Exception {
        String key = "key";
        String value = "hello";
        this.createBoundedObjectStore(1);
        this.store.store((Serializable)((Object)key), (Serializable)((Object)value));
        this.assertObjectsInStore(key);
        String retrieved = (String)((Object)this.store.retrieve((Serializable)((Object)key)));
        InMemoryStoreTestCase.assertEquals((String)value, (String)retrieved);
        this.store.remove((Serializable)((Object)key));
        this.assertObjectsExpired(key);
    }

    public void testExpiringUnboundedStore() throws Exception {
        this.createUnboundedObjectStore();
        this.storeObjects("1", "2", "3");
        this.store.expire();
        this.assertObjectsInStore("1", "2", "3");
    }

    public void testMaxSize() throws Exception {
        int maxEntries = 3;
        this.createBoundedObjectStore(maxEntries);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("1", "2", "3");
        this.store.store((Serializable)((Object)"4"), (Serializable)((Object)"4"));
        InMemoryStoreTestCase.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        this.store.expire();
        this.assertObjectsExpired("1");
        this.assertObjectsInStore("2", "3", "4");
        this.storeObjects("5");
        this.store.expire();
        this.assertObjectsExpired("2");
        this.assertObjectsInStore("3", "4", "5");
        this.storeObjects("6", "7", "8", "9");
        this.store.expire();
        this.assertObjectsInStore("7", "8", "9");
        this.assertObjectsExpired("3", "4", "5", "6");
    }

    private void storeObjects(String ... objects) throws Exception {
        for (String entry : objects) {
            this.store.store((Serializable)((Object)entry), (Serializable)((Object)entry));
        }
    }

    private void assertObjectsInStore(String ... identifiers) throws Exception {
        for (String id : identifiers) {
            String message = "id " + id + " not in store " + this.store;
            InMemoryStoreTestCase.assertTrue((String)message, (boolean)this.store.contains((Serializable)((Object)id)));
        }
    }

    private void assertObjectsExpired(String ... identifiers) throws Exception {
        for (String id : identifiers) {
            InMemoryStoreTestCase.assertFalse((boolean)this.store.contains((Serializable)((Object)id)));
        }
    }

    private void createTimedObjectStore(int timeToLive) throws InitialisationException {
        int expireInterval = 1000;
        InMemoryStoreTestCase.assertTrue((String)"objects' time to live must be greater than the expire interval", (timeToLive > expireInterval ? 1 : 0) != 0);
        this.store = new InMemoryObjectStore();
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(timeToLive);
        this.store.setExpirationInterval(expireInterval);
        this.store.initialise();
    }

    private void createBoundedObjectStore(int numberOfEntries) throws InitialisationException {
        this.createNonexpiringObjectStore();
        this.store.setName("bounded");
        this.store.setMaxEntries(numberOfEntries);
        this.store.initialise();
    }

    private void createUnboundedObjectStore() throws InitialisationException {
        this.createNonexpiringObjectStore();
        this.store.setMaxEntries(-1);
        this.store.initialise();
    }

    private void createNonexpiringObjectStore() {
        this.store = new NonExpiringInMemoryObjectStore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonExpiringInMemoryObjectStore
    extends InMemoryObjectStore<String> {
        private CountDownLatch expireLatch;

        public NonExpiringInMemoryObjectStore() {
            this.setEntryTTL(-1);
            this.setExpirationInterval(Integer.MAX_VALUE);
            this.expireLatch = new CountDownLatch(1);
        }

        public void initialise() throws InitialisationException {
            super.initialise();
            try {
                this.expireLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Interrupted while waiting for the first expire", ie);
            }
        }

        public void expire() {
            super.expire();
            this.expireLatch.countDown();
        }
    }
}

