/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.MapUtils;
import org.mule.util.PropertiesUtils;

public class PropertiesUtilsTestCase
extends AbstractMuleTestCase {
    public void testRemoveNameSpacePrefix() {
        String temp = "this.is.a.namespace";
        String result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"namespace", (String)result);
        temp = "this.namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"namespace", (String)result);
        temp = "namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"namespace", (String)result);
        temp = "this_is-a-namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"this_is-a-namespace", (String)result);
    }

    public void testRemoveXMLNameSpacePrefix() {
        String temp = "j:namespace";
        String result = PropertiesUtils.removeXmlNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"namespace", (String)result);
        temp = "this-namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"this-namespace", (String)result);
        temp = "namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        PropertiesUtilsTestCase.assertEquals((String)"namespace", (String)result);
    }

    public void testRemoveNamespaces() throws Exception {
        Map<String, String> props = new HashMap<String, String>();
        props.put("blah.booleanProperty", "true");
        props.put("blah.blah.doubleProperty", NumberFormat.getInstance().format(0.124));
        props.put("blah.blah.Blah.intProperty", "14");
        props.put("longProperty", "999999999");
        props.put("3456.stringProperty", "string");
        props = PropertiesUtils.removeNamespaces(props);
        PropertiesUtilsTestCase.assertTrue((boolean)MapUtils.getBooleanValue(props, (Object)"booleanProperty", (boolean)false));
        PropertiesUtilsTestCase.assertEquals((double)0.124, (double)0.0, (double)MapUtils.getDoubleValue(props, (Object)"doubleProperty", (double)0.0));
        PropertiesUtilsTestCase.assertEquals((int)14, (int)MapUtils.getIntValue(props, (Object)"intProperty", (int)0));
        PropertiesUtilsTestCase.assertEquals((float)1.0E9f, (float)0.0f, (float)MapUtils.getLongValue(props, (Object)"longProperty", (long)0L));
        PropertiesUtilsTestCase.assertEquals((String)"string", (String)MapUtils.getString(props, (Object)"stringProperty", (String)""));
    }

    public void testMaskedProperties() {
        PropertiesUtilsTestCase.assertNull((Object)PropertiesUtils.maskedPropertyValue(null));
        PropertiesUtilsTestCase.assertNull((Object)PropertiesUtils.maskedPropertyValue((Map.Entry)new DefaultMapEntry(null, (Object)"value")));
        PropertiesUtilsTestCase.assertNull((Object)PropertiesUtils.maskedPropertyValue((Map.Entry)new DefaultMapEntry((Object)"key", null)));
        DefaultMapEntry property = new DefaultMapEntry((Object)"secretname", (Object)"secret");
        PropertiesUtilsTestCase.assertTrue((boolean)"secret".equals(PropertiesUtils.maskedPropertyValue((Map.Entry)property)));
        PropertiesUtils.registerMaskedPropertyName((String)"secretname");
        String masked = PropertiesUtils.maskedPropertyValue((Map.Entry)property);
        PropertiesUtilsTestCase.assertFalse((boolean)"secret".equals(masked));
        PropertiesUtilsTestCase.assertTrue((boolean)masked.startsWith("*"));
    }
}

