/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.io.IOException;
import java.util.HashMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ExpressionFilterTestCase
extends AbstractMuleTestCase {
    public void testHeaderFilter() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testVariableFilter() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testHeaderFilterWithNot() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testVariableFilterWithNot() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo!=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setInvocationProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testHeaderFilterWithNotNull() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=null");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testVariableFilterWithNotNull() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo!=null");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        ExpressionFilterTestCase.assertNull((Object)filter.getPattern());
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("(.*) brown fox");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    public void testRegexFilter() {
        ExpressionFilter filter = new ExpressionFilter("regex", "The quick (.*)");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertNotNull((Object)filter.getExpression());
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox", muleContext)));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick ", muleContext)));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox", muleContext)) ? 1 : 0) != 0);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"he quick brown fox", muleContext)) ? 1 : 0) != 0);
    }

    public void testRegexFilterWithAngleBrackets() {
        ExpressionFilter filter = new ExpressionFilter("#[regex:The number is [1-9]]");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertNotNull((Object)filter.getExpression());
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The number is 4", muleContext)));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"Say again?", muleContext)));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The number is 0", muleContext)));
    }

    public void testExceptionTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("exception-type:java.lang.Exception");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage m = new DefaultMuleMessage((Object)"test", muleContext);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)m));
        filter = new ExpressionFilter("exception-type:java.io.IOException");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)m));
    }

    public void testPayloadTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("payload-type:org.mule.tck.testmodels.fruit.Apple");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Apple(), muleContext)));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test", muleContext)) ? 1 : 0) != 0);
        filter = new ExpressionFilter("payload-type:java.lang.String");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test", muleContext)));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Exception("test"), muleContext)) ? 1 : 0) != 0);
    }

    public void testWildcardFilterMultiplePatterns() {
        ExpressionFilter filter = new ExpressionFilter("wildcard:* brown*, The*");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox", muleContext)));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)" brown fox", muleContext)));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox", muleContext)));
    }

    public void testTrueString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(true);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"true", muleContext)));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"TRUE", muleContext)));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"tRuE", muleContext)));
    }

    public void testFalseString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"false", muleContext)));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"FALSE", muleContext)));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"faLSe", muleContext)));
    }

    public void testExpressionFilter() {
        ExpressionFilter filter = new ExpressionFilter("mule:message.header(foo?)");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", muleContext)));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("foo", "bar");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", headers, muleContext)));
    }

    public void testExpressionFilterWithFullSyntax() {
        ExpressionFilter filter = new ExpressionFilter("#[mule:message.header(foo?)]");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", muleContext)));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("foo", "bar");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", headers, muleContext)));
    }
}

