/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.FirstSuccessful;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

public class FirstSuccessfulTestCase
extends AbstractMuleTestCase {
    private static final String EXCEPTION_SEEN = "EXCEPTION WAS SEEN";

    public FirstSuccessfulTestCase() {
        this.setStartContext(true);
    }

    public void testFirstSuccessful() throws Exception {
        MuleSession session = FirstSuccessfulTestCase.getTestSession(FirstSuccessfulTestCase.getTestService(), muleContext);
        FirstSuccessful fs = this.createFirstSuccessfulRouter(new TestProcessor("abc"), new TestProcessor("def"), new TestProcessor("ghi"));
        fs.initialise();
        FirstSuccessfulTestCase.assertEquals((String)"No abc", (String)this.getPayload((MessageProcessor)fs, session, ""));
        FirstSuccessfulTestCase.assertEquals((String)"No def", (String)this.getPayload((MessageProcessor)fs, session, "abc"));
        FirstSuccessfulTestCase.assertEquals((String)"No ghi", (String)this.getPayload((MessageProcessor)fs, session, "abcdef"));
        FirstSuccessfulTestCase.assertEquals((String)EXCEPTION_SEEN, (String)this.getPayload((MessageProcessor)fs, session, "abcdefghi"));
        FirstSuccessfulTestCase.assertEquals((String)"No def", (String)this.getPayload((MessageProcessor)fs, session, "ABC"));
        FirstSuccessfulTestCase.assertEquals((String)"No ghi", (String)this.getPayload((MessageProcessor)fs, session, "ABCDEF"));
        FirstSuccessfulTestCase.assertEquals((String)EXCEPTION_SEEN, (String)this.getPayload((MessageProcessor)fs, session, "ABCDEFGHI"));
    }

    public void testFailureExpression() throws Exception {
        MessageProcessor intSetter = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)1);
                return event;
            }
        };
        FirstSuccessful fs = this.createFirstSuccessfulRouter(new MessageProcessor[]{intSetter, new StringAppendTransformer("abc")});
        fs.setFailureExpression("#[payload-type:java.lang.Integer]");
        fs.initialise();
        FirstSuccessfulTestCase.assertEquals((String)"abc", (String)fs.process(FirstSuccessfulTestCase.getTestEvent("")).getMessageAsString());
    }

    public void testRouteReturnsNullEvent() throws Exception {
        MessageProcessor nullReturningMp = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        };
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullReturningMp);
        fs.initialise();
        FirstSuccessfulTestCase.assertNull((Object)fs.process(FirstSuccessfulTestCase.getTestEvent("")));
    }

    public void testRouteReturnsNullMessage() throws Exception {
        MessageProcessor nullEventMp = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return new DefaultMuleEvent(null, event);
            }
        };
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullEventMp);
        fs.initialise();
        try {
            fs.process(FirstSuccessfulTestCase.getTestEvent(""));
            FirstSuccessfulTestCase.fail((String)"Exception expected");
        }
        catch (CouldNotRouteOutboundMessageException couldNotRouteOutboundMessageException) {
            // empty catch block
        }
    }

    public void testProcessingIsForcedOnSameThread() throws Exception {
        MessageProcessor checkForceSyncFlag = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                MuleMessage message = event.getMessage();
                Boolean deliveryForcedInSameThread = (Boolean)message.getInboundProperty("MULE_FORCE_SYNC", (Object)Boolean.FALSE);
                Assert.assertTrue((boolean)deliveryForcedInSameThread);
                return event;
            }
        };
        FirstSuccessful router = this.createFirstSuccessfulRouter(checkForceSyncFlag);
        router.initialise();
        router.process(FirstSuccessfulTestCase.getTestEvent("Test Message"));
    }

    private FirstSuccessful createFirstSuccessfulRouter(MessageProcessor ... processors) throws MuleException {
        FirstSuccessful fs = new FirstSuccessful();
        fs.setMuleContext(muleContext);
        List<MessageProcessor> routes = Arrays.asList(processors);
        fs.setRoutes(routes);
        return fs;
    }

    private String getPayload(MessageProcessor mp, MuleSession session, String message) throws Exception {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)message, muleContext);
        try {
            MuleEvent event = mp.process((MuleEvent)new DefaultMuleEvent((MuleMessage)msg, null, session));
            MuleMessage returnedMessage = event.getMessage();
            if (returnedMessage.getExceptionPayload() != null) {
                return EXCEPTION_SEEN;
            }
            return returnedMessage.getPayloadAsString();
        }
        catch (Exception ex) {
            return EXCEPTION_SEEN;
        }
    }

    private static class TestProcessor
    implements MessageProcessor {
        private String rejectIfMatches;

        TestProcessor(String rejectIfMatches) {
            this.rejectIfMatches = rejectIfMatches;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            try {
                DefaultMuleMessage msg;
                String payload = event.getMessage().getPayloadAsString();
                if (payload.indexOf(this.rejectIfMatches) >= 0) {
                    throw new DefaultMuleException("Saw " + this.rejectIfMatches);
                }
                if (payload.toLowerCase().indexOf(this.rejectIfMatches) >= 0) {
                    msg = new DefaultMuleMessage(null, muleContext);
                    msg.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new Exception()));
                } else {
                    msg = new DefaultMuleMessage((Object)("No " + this.rejectIfMatches), muleContext);
                }
                return new DefaultMuleEvent((MuleMessage)msg, null, event.getSession());
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }
}

