/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.filter.Filter;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.ChoiceRouter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ChoiceRouterTestCase
extends AbstractMuleTestCase {
    private ChoiceRouter choiceRouter;

    protected void doSetUp() throws Exception {
        super.setDisposeManagerPerSuite(true);
        super.doSetUp();
        this.choiceRouter = new ChoiceRouter();
    }

    public void testNoRoute() throws Exception {
        try {
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo"));
            ChoiceRouterTestCase.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            ChoiceRouterTestCase.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    public void testOnlyDefaultRoute() throws Exception {
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        ChoiceRouterTestCase.assertEquals((String)"foo:default", (String)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo")).getMessageAsString());
    }

    public void testNoMatchingNorDefaultRoute() throws Exception {
        try {
            this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo"));
            ChoiceRouterTestCase.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            ChoiceRouterTestCase.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    public void testNoMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        ChoiceRouterTestCase.assertEquals((String)"foo:default", (String)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo")).getMessageAsString());
    }

    public void testMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        ChoiceRouterTestCase.assertEquals((String)"zap:bar", (String)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    public void testMatchingRouteWithStatistics() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        ChoiceRouterTestCase.assertEquals((String)"zap:bar", (String)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    public void testAddAndDeleteRoute() throws Exception {
        try {
            TestMessageProcessor mp = new TestMessageProcessor("bar");
            this.choiceRouter.addRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"zap"));
            this.choiceRouter.removeRoute((MessageProcessor)mp);
            this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap"));
            ChoiceRouterTestCase.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            ChoiceRouterTestCase.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    public void testUpdateRoute() throws Exception {
        TestMessageProcessor mp = new TestMessageProcessor("bar");
        this.choiceRouter.addRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"paz"));
        this.choiceRouter.updateRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"zap"));
        ChoiceRouterTestCase.assertEquals((String)"zap:bar", (String)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    public void testRemovingUpdatingMissingRoutes() {
        this.choiceRouter.updateRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.removeRoute((MessageProcessor)new TestMessageProcessor("rab"));
    }
}

