/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractLifecycleTracker;
import org.mule.registry.TransientRegistry;
import org.mule.tck.AbstractMuleTestCase;

public class TransientRegistryTestCase
extends AbstractMuleTestCase {
    public void testObjectLifecycle() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testJSR250ObjectLifecycle() throws Exception {
        muleContext.start();
        JSR250ObjectLifecycleTracker tracker = new JSR250ObjectLifecycleTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycle() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)1);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassInjectors() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)2);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleAndInjectors() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)3);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleStates() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise]", (String)tracker.getTracker().toString());
        try {
            muleContext.initialise();
            TransientRegistryTestCase.fail((String)"context already initialised");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        try {
            muleContext.start();
            TransientRegistryTestCase.fail((String)"context already started");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.stop();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        try {
            muleContext.stop();
            TransientRegistryTestCase.fail((String)"context already stopped");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
        try {
            muleContext.dispose();
            TransientRegistryTestCase.fail((String)"context already disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testObjectLifecycleRestart() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        muleContext.stop();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceDisposeFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("dispose");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            reg.registerObject("test", (Object)tracker);
            TransientRegistryTestCase.fail((String)"Cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    public void testLifecycleStateOutOfSequenceStartFirst() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStopFirst() throws Exception {
        try {
            muleContext.stop();
            TransientRegistryTestCase.fail((String)"Cannot not stop the context if not started");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.start();
        muleContext.stop();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceDisposeFirst() throws Exception {
        muleContext.dispose();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            muleContext.getRegistry().registerObject("test", (Object)tracker);
            TransientRegistryTestCase.fail((String)"cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JSR250ObjectLifecycleTracker
    implements MuleContextAware {
        private final List<String> tracker = new ArrayList<String>();

        public List<String> getTracker() {
            return this.tracker;
        }

        public void setMuleContext(MuleContext context) {
            this.tracker.add("setMuleContext");
        }

        @PostConstruct
        public void init() {
            this.tracker.add("initialise");
        }

        @PreDestroy
        public void dispose() {
            this.tracker.add("dispose");
        }
    }

    public class InterfaceBasedTracker
    extends AbstractLifecycleTracker {
    }
}

