/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.SecurityFilter;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.SecurityFilterMessageProcessor;
import org.mule.tck.security.TestSecurityFilter;

public class SecurityFilterMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    @Test
    public void testFilterPass() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(true);
        InboundEndpoint endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)securityFilter, MessageExchangePattern.REQUEST_RESPONSE, null);
        SecurityFilterMessageProcessor mp = new SecurityFilterMessageProcessor((SecurityFilter)securityFilter);
        AbstractMessageProcessorTestCase.TestListener listner = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listner);
        MuleEvent inEvent = this.createTestInboundEvent(endpoint);
        MuleEvent resultEvent = mp.process(inEvent);
        SecurityFilterMessageProcessorTestCase.assertNotNull((Object)listner.sensedEvent);
        SecurityFilterMessageProcessorTestCase.assertSame((Object)inEvent, (Object)listner.sensedEvent);
        SecurityFilterMessageProcessorTestCase.assertEquals((Object)inEvent, (Object)resultEvent);
    }

    @Test
    public void testFilterFail() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(false);
        InboundEndpoint endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)securityFilter, MessageExchangePattern.REQUEST_RESPONSE, null);
        SecurityFilterMessageProcessor mp = new SecurityFilterMessageProcessor((SecurityFilter)securityFilter);
        AbstractMessageProcessorTestCase.TestListener listner = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listner);
        MuleEvent inEvent = this.createTestInboundEvent(endpoint);
        RequestContext.setEvent((MuleEvent)inEvent);
        try {
            MuleEvent resultEvent = mp.process(inEvent);
            SecurityFilterMessageProcessorTestCase.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            // empty catch block
        }
        SecurityFilterMessageProcessorTestCase.assertNull((Object)listner.sensedEvent);
    }
}

