/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.ExceptionHandlingMessageProcessor;
import org.mule.transport.NullPayload;

public class ExceptionHandlingMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    private AbstractMessageProcessorTestCase.TestExceptionListener exceptionListener;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.exceptionListener = new AbstractMessageProcessorTestCase.TestExceptionListener();
    }

    public void testNoCatch() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        AbstractMessageProcessorTestCase.TestListener listener = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listener);
        MuleEvent event = this.createTestOutboundEvent(endpoint);
        MuleEvent result = mp.process(event);
        ExceptionHandlingMessageProcessorTestCase.assertSame((Object)event, (Object)listener.sensedEvent);
        ExceptionHandlingMessageProcessorTestCase.assertSame((Object)event, (Object)result);
        ExceptionHandlingMessageProcessorTestCase.assertNull((Object)this.exceptionListener.sensedException);
    }

    public void testCatchRuntimeExceptionSync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(endpoint, this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)resultEvent);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        ExceptionHandlingMessageProcessorTestCase.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        ExceptionHandlingMessageProcessorTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    public void testCatchRuntimeExceptionAsync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, MessageExchangePattern.ONE_WAY, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(endpoint, this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)resultEvent);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        ExceptionHandlingMessageProcessorTestCase.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        ExceptionHandlingMessageProcessorTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    public void testCatchDispatchExceptionSync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(endpoint, this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)resultEvent);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        ExceptionHandlingMessageProcessorTestCase.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        ExceptionHandlingMessageProcessorTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    public void testCatchDispatchExceptionAsync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, MessageExchangePattern.ONE_WAY, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(endpoint, this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)resultEvent);
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        ExceptionHandlingMessageProcessorTestCase.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        ExceptionHandlingMessageProcessorTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        ExceptionHandlingMessageProcessorTestCase.assertNotNull((Object)this.exceptionListener.sensedException);
    }
}

