/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mule.lifecycle.JSR250ObjectLifecycleTracker;
import org.mule.tck.AbstractMuleTestCase;

public class JSR250ObjectLifcycleTestCase
extends AbstractMuleTestCase {
    public void testNormalBehaviour() throws Exception {
        JSR250ObjectLifecycleTracker tracker = new JSR250ObjectLifecycleTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        JSR250ObjectLifcycleTestCase.assertEquals((String)"[setMuleContext, initialise, dispose]", (String)tracker.getTracker().toString());
    }

    public void testTwoPostConstructAnnotations() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new DupePostConstructJSR250ObjectLifecycleTracker());
            JSR250ObjectLifcycleTestCase.fail((String)"Object has two @PostConstruct annotations");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTwoPreDestroyAnnotations() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new DupePreDestroyJSR250ObjectLifecycleTracker());
            JSR250ObjectLifcycleTestCase.fail((String)"Object has two @PreDestroy annotations");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBadReturnTypePostConstructMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadReturnTypePostConstructLifecycleMethodObject());
            JSR250ObjectLifcycleTestCase.fail((String)"PostContruct Lifecycle method has a non-void return type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBadParamPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadParamPreDestroyLifecycleMethodObject());
            JSR250ObjectLifcycleTestCase.fail((String)"PreDestroy Lifecycle method has a parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBadStaticPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadStaticMethodPostConstructLifecycleMethodObject());
            JSR250ObjectLifcycleTestCase.fail((String)"PostConstruct Lifecycle method is static");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBadCheckedExceptionPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadCheckedExceptionPreDestroyLifecycleMethodObject());
            JSR250ObjectLifcycleTestCase.fail((String)"PreDestroy Lifecycle method throws a checked exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public class BadCheckedExceptionPreDestroyLifecycleMethodObject {
        @PreDestroy
        public void destroy() throws Exception {
        }
    }

    public static class BadStaticMethodPostConstructLifecycleMethodObject {
        @PostConstruct
        public static void init() {
        }
    }

    public class BadParamPreDestroyLifecycleMethodObject {
        @PreDestroy
        public void destroy(boolean foo) {
        }
    }

    public class BadReturnTypePostConstructLifecycleMethodObject {
        @PostConstruct
        public boolean init() {
            return true;
        }
    }

    public class DupePreDestroyJSR250ObjectLifecycleTracker
    extends JSR250ObjectLifecycleTracker {
        @PreDestroy
        public void dispose2() {
            this.getTracker().add("dispose 2");
        }
    }

    public class DupePostConstructJSR250ObjectLifecycleTracker
    extends JSR250ObjectLifecycleTracker {
        @PostConstruct
        public void init2() {
            this.getTracker().add("initialise 2");
        }
    }
}

