/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.expression.MessageHeadersExpressionEvaluator;
import org.mule.expression.MessageHeadersListExpressionEvaluator;
import org.mule.routing.correlation.CorrelationPropertiesExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.UUID;

public class HeadersExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private Map<String, Object> props;

    public void doSetUp() {
        this.props = new HashMap<String, Object>(3);
        this.props.put("foo", "foovalue");
        this.props.put("bar", "barvalue");
        this.props.put("baz", "bazvalue");
    }

    public void testSingleHeader() throws Exception {
        MessageHeaderExpressionEvaluator eval = new MessageHeaderExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"foovalue", (Object)result);
        result = eval.evaluate("foo?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"foovalue", (Object)result);
        result = eval.evaluate("fool?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        message.addInboundProperties(Collections.singletonMap("testProp", "value"));
        result = eval.evaluate("testProp?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        result = eval.evaluate("INBOUND:testProp", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"value", (Object)result);
    }

    public void testMapHeaders() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("foo?, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("fool?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        try {
            eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        result = eval.evaluate("*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    public void testHeadersWithScopes() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("fazvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz, INVOCATION:faz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("fazvalue"));
        try {
            eval.evaluate("OUTBOUND:foo, baz, faz", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"faz is not in outbound scope and is not optional");
        }
        catch (RequiredValueException e) {
            // empty catch block
        }
        result = eval.evaluate("OUTBOUND:foo, faz?, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        message.setInboundProperty("infoo", (Object)"infoovalue");
        result = eval.evaluate("infoo?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("INBOUND:infoo?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)1, (int)((Map)result).size());
    }

    public void testListHeaders() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("foo?, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("fool?", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        try {
            eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListHeadersWithScopes() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("fazvalue"));
        try {
            eval.evaluate("OUTBOUND:foo, baz, faz", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"faz is not in outbound scope and is not optional");
        }
        catch (RequiredValueException e) {
            // empty catch block
        }
        result = eval.evaluate("OUTBOUND:foo, faz?, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
    }

    public void testListHeadersWithWildcard() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("ba*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        result = eval.evaluate("x*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = eval.evaluate("ba*, f*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
    }

    public void testMapHeadersWithWildcards() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("ba*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("x*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("ba*, f*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    public void testSingleHeaderUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"foovalue", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[header:foo?]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"foovalue", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[header:fool?]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[header:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testMapHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers:foo, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:foo?, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:fool?]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[headers:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testMapHeadersWithWildcardsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers:*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:ba*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:x*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[headers:ba*, f*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    public void testListHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:foo, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:foo?, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:fool?]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[headers-list:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testListHeadersWithWildCardsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:x*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*, f*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("foovalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("bazvalue"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("barvalue"));
    }

    public void testCorrelationManagerCorrelationId() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        String correlationId = UUID.getUUID();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setCorrelationId(correlationId);
        Object result = evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)correlationId, (Object)result);
    }

    public void testCorrelationManagerNullResult() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setUniqueId(null);
        try {
            evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Null result on CorrelationPropertiesExpressionEvaluator must throw");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCorrelationManagerUniqueId() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = evaluator.evaluate("MULE_MESSAGE_ID", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)result);
    }

    public void testCorrelationManagerInvalidKey() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        try {
            evaluator.evaluate("invalid-key", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"invalid key on CorrelationPropertiesExpressionEvaluator must fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

