/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.expression.ExpressionConfig;
import org.mule.tck.AbstractMuleTestCase;

public class ExpressionConfigTestCase
extends AbstractMuleTestCase {
    public void testConfig() throws Exception {
        ExpressionConfig config = new ExpressionConfig("foo=bar", "header", null, "$[", "]");
        config.validate(muleContext.getExpressionManager());
        ExpressionConfigTestCase.assertEquals((String)"$[header:foo=bar]", (String)config.getFullExpression(muleContext.getExpressionManager()));
        config = new ExpressionConfig("foo,bar", "headers", null);
        config.validate(muleContext.getExpressionManager());
        ExpressionConfigTestCase.assertEquals((String)"#[headers:foo,bar]", (String)config.getFullExpression(muleContext.getExpressionManager()));
        config = new ExpressionConfig();
        config.parse("#[attachment:baz]");
        config.validate(muleContext.getExpressionManager());
        ExpressionConfigTestCase.assertEquals((String)"attachment", (String)config.getEvaluator());
        ExpressionConfigTestCase.assertEquals((String)"baz", (String)config.getExpression());
        ExpressionConfigTestCase.assertNull((Object)config.getCustomEvaluator());
    }

    public void testCustomConfig() throws Exception {
        muleContext.getExpressionManager().registerEvaluator(new ExpressionEvaluator(){

            public Object evaluate(String expression, MuleMessage message) {
                return null;
            }

            public void setName(String name) {
            }

            public String getName() {
                return "customEval";
            }
        });
        ExpressionConfig config = new ExpressionConfig("foo,bar", "custom", "customEval");
        config.validate(muleContext.getExpressionManager());
        ExpressionConfigTestCase.assertEquals((String)"#[customEval:foo,bar]", (String)config.getFullExpression(muleContext.getExpressionManager()));
    }
}

