/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.outbound.OutboundResponsePropertiesMessageProcessor;

public class OutboundResponsePropertiesMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    private static String MY_PROPERTY_KEY = "myProperty";
    private static String MY_PROPERTY_VAL = "myPropertyValue";
    private static String MULE_CORRELATION_ID_VAL = "152";

    public void testProcess() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        OutboundResponsePropertiesMessageProcessor mp = new OutboundResponsePropertiesMessageProcessor(endpoint);
        mp.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(event.getMessage().getPayload(), muleContext), null, null);
            }
        });
        MuleEvent event = this.createTestOutboundEvent(endpoint);
        event.getMessage().setOutboundProperty(MY_PROPERTY_KEY, (Object)MY_PROPERTY_VAL);
        event.getMessage().setOutboundProperty("MULE_CORRELATION_ID", (Object)MULE_CORRELATION_ID_VAL);
        MuleEvent result = mp.process(event);
        OutboundResponsePropertiesMessageProcessorTestCase.assertNotNull((Object)result);
        OutboundResponsePropertiesMessageProcessorTestCase.assertEquals((String)"Test Message", (String)result.getMessageAsString());
        OutboundResponsePropertiesMessageProcessorTestCase.assertEquals((Object)MY_PROPERTY_VAL, (Object)result.getMessage().getOutboundProperty(MY_PROPERTY_KEY));
        OutboundResponsePropertiesMessageProcessorTestCase.assertEquals((Object)MULE_CORRELATION_ID_VAL, (Object)result.getMessage().getOutboundProperty("MULE_CORRELATION_ID"));
    }

    protected void customizeEndpointBuilder(EndpointBuilder endpointBuilder) {
        endpointBuilder.setProperty((Object)"responseProperties", (Object)"myProperty");
    }
}

