/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.Connector;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class EndpointFactoryTestCase
extends AbstractMuleTestCase {
    public void testCreateInboundEndpoint() throws Exception {
        String uri = "test://address";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals(DefaultInboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
    }

    public void testCreateInboundEndpointFromGlobalEndpoint() throws Exception {
        muleContext.getRegistry().registerEndpointBuilder("myGlobalEndpoint", (EndpointBuilder)new EndpointURIEndpointBuilder("test://address", muleContext));
        String uri = "myGlobalEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        try {
            InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
            EndpointFactoryTestCase.assertEquals(DefaultInboundEndpoint.class, ep.getClass());
            EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
            EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
        }
        catch (Exception e) {
            EndpointFactoryTestCase.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testCreateInboundEndpointFromNamedConcreteEndpoint() throws Exception {
        muleContext.getRegistry().registerEndpointBuilder("&myNamedConcreateEndpoint", (EndpointBuilder)new EndpointURIEndpointBuilder("test://address", muleContext));
        String uri = "&myNamedConcreateEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals(DefaultInboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
    }

    public void testCreateOutboundEndpoint() throws Exception {
        String uri = "test://address";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        OutboundEndpoint ep = endpointFactory.getOutboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals(DefaultOutboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
    }

    public void testCreateoutboundEndpointFromGlobalEndpoint() throws Exception {
        muleContext.getRegistry().registerEndpointBuilder("myGlobalEndpoint", (EndpointBuilder)new EndpointURIEndpointBuilder("test://address", muleContext));
        String uri = "myGlobalEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        OutboundEndpoint ep = endpointFactory.getOutboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals(DefaultOutboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
    }

    public void testCreateoutboundEndpointFromNamedConcreteEndpoint() throws Exception {
        muleContext.getRegistry().registerEndpointBuilder("&myNamedConcreateEndpoint", (EndpointBuilder)new EndpointURIEndpointBuilder("test://address", muleContext));
        String uri = "&myNamedConcreateEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        OutboundEndpoint ep = endpointFactory.getOutboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals(DefaultOutboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
    }

    public void testCreateInboundEndpointWithBuilder() throws Exception {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("test://address", muleContext);
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint((EndpointBuilder)builder);
        EndpointFactoryTestCase.assertEquals(DefaultInboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
    }

    public void testCreateOutboundEndpointWithBuilder() throws Exception {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("test://address", muleContext);
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        OutboundEndpoint ep = endpointFactory.getOutboundEndpoint((EndpointBuilder)builder);
        EndpointFactoryTestCase.assertEquals(DefaultOutboundEndpoint.class, ep.getClass());
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
    }

    public void testCreateEndpoint() throws MuleException {
        String uri = "test://address";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
    }

    public void testCreateEndpointFromGlobalEndpoint() throws MuleException {
        MuleRegistry r = muleContext.getRegistry();
        r.registerObject("myGlobalEndpoint", (Object)new EndpointURIEndpointBuilder("test://address", muleContext), (Object)muleContext);
        String uri = "myGlobalEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        try {
            InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
            EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        }
        catch (Exception e) {
            EndpointFactoryTestCase.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testCreateEndpointFromNamedConcreteEndpoint() throws MuleException {
        MuleRegistry r = muleContext.getRegistry();
        r.registerObject("&myNamedConcreteEndpoint", (Object)new EndpointURIEndpointBuilder("test://address", muleContext));
        String uri = "&myNamedConcreteEndpoint";
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint(uri);
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
    }

    public void testCreateEndpointByCustomizingEndpointBuilder() throws MuleException {
        TestConnector testConnector1 = new TestConnector(muleContext);
        testConnector1.setName("testConnector1");
        TestConnector testConnector2 = new TestConnector(muleContext);
        testConnector2.setName("testConnector2");
        muleContext.getRegistry().registerConnector((Connector)testConnector1);
        muleContext.getRegistry().registerConnector((Connector)testConnector2);
        String globalEndpointName = "concreteEndpoint";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://address", muleContext);
        endpointBuilder.setConnector((Connector)testConnector1);
        muleContext.getRegistry().registerObject(globalEndpointName, (Object)endpointBuilder);
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(muleContext);
        EndpointBuilder endpointBuilder1 = endpointFactory.getEndpointBuilder(globalEndpointName);
        EndpointFactoryTestCase.assertNotSame((Object)endpointBuilder1, (Object)endpointBuilder);
        EndpointFactoryTestCase.assertTrue((boolean)endpointBuilder1.equals(endpointBuilder));
        EndpointBuilder endpointBuilder2 = endpointFactory.getEndpointBuilder(globalEndpointName);
        EndpointFactoryTestCase.assertNotSame((Object)endpointBuilder2, (Object)endpointBuilder);
        EndpointFactoryTestCase.assertTrue((boolean)endpointBuilder2.equals(endpointBuilder));
        EndpointFactoryTestCase.assertNotSame((Object)endpointBuilder1, (Object)endpointBuilder2);
        EndpointFactoryTestCase.assertTrue((boolean)endpointBuilder1.equals(endpointBuilder2));
        EndpointFactoryTestCase.assertEquals((int)endpointBuilder1.hashCode(), (int)endpointBuilder2.hashCode());
        endpointBuilder1.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        endpointBuilder1.setResponseTimeout(99);
        InboundEndpoint ep = endpointFactory.getInboundEndpoint(endpointBuilder1);
        EndpointFactoryTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)ep.getExchangePattern());
        EndpointFactoryTestCase.assertEquals((int)99, (int)ep.getResponseTimeout());
        EndpointFactoryTestCase.assertNotNull((Object)ep.getConnector());
        EndpointFactoryTestCase.assertEquals((Object)((Object)testConnector1), (Object)ep.getConnector());
        endpointBuilder2.setExchangePattern(MessageExchangePattern.ONE_WAY);
        endpointBuilder2.setResponseTimeout(0);
        endpointBuilder2.setConnector((Connector)testConnector2);
        InboundEndpoint ep2 = endpointFactory.getInboundEndpoint(endpointBuilder2);
        EndpointFactoryTestCase.assertEquals((String)ep2.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertEquals((Object)MessageExchangePattern.ONE_WAY, (Object)ep2.getExchangePattern());
        EndpointFactoryTestCase.assertEquals((int)0, (int)ep2.getResponseTimeout());
        EndpointFactoryTestCase.assertNotNull((Object)ep.getConnector());
        EndpointFactoryTestCase.assertEquals((Object)((Object)testConnector2), (Object)ep2.getConnector());
        InboundEndpoint ep3 = endpointFactory.getInboundEndpoint(endpointBuilder1);
        EndpointFactoryTestCase.assertEquals((String)ep3.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointFactoryTestCase.assertTrue((ep3.getResponseTimeout() != 0 ? 1 : 0) != 0);
        EndpointFactoryTestCase.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)ep3.getExchangePattern());
        EndpointFactoryTestCase.assertNotNull((Object)ep.getConnector());
        EndpointFactoryTestCase.assertEquals((Object)((Object)testConnector1), (Object)ep3.getConnector());
    }
}

