/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.component.DefaultComponentLifecycleAdapter;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.services.UniqueComponent;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.util.ExceptionUtils;
import org.mule.util.pool.AbstractPoolingTestCase;

public class PooledJavaComponentTestCase
extends AbstractPoolingTestCase {
    public void testComponentCreation() throws Exception {
        PrototypeObjectFactory objectFactory = this.getDefaultObjectFactory();
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)objectFactory, pp);
        component.setMuleContext(muleContext);
        PooledJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        PooledJavaComponentTestCase.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        PooledJavaComponentTestCase.assertEquals(Orange.class, (Object)component.getObjectType());
        PooledJavaComponentTestCase.assertNotNull((Object)component.getPoolingProfile());
        PooledJavaComponentTestCase.assertEquals((Object)pp, (Object)component.getPoolingProfile());
    }

    public void testPoolManagement() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getDefaultObjectFactory(), this.createDefaultPoolingProfile());
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
        component.setFlowConstruct((FlowConstruct)PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
        component.start();
        PooledJavaComponentTestCase.assertNotNull((Object)component.lifecycleAdapterPool);
        component.stop();
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
    }

    public void testStartStop() throws Exception {
        PooledJavaComponent component = this.createPooledComponent();
        PooledJavaComponentTestCase.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        component.stop();
        component.start();
        Object la1 = ((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject;
        Object la2 = ((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject;
        PooledJavaComponentTestCase.assertNotSame((Object)la1, (Object)la2);
    }

    public void testCreateLifecycleAdapters() throws Exception {
        PooledJavaComponent component = this.createPooledComponent();
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed2 = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed2);
        PooledJavaComponentTestCase.assertEquals((int)2, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testFailOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = this.createPooledComponent(pp);
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        try {
            component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.fail((String)"Should throw an Exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testBlockExpiryOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = this.createPooledComponent(pp);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        long startTime = System.currentTimeMillis();
        try {
            component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.fail((String)"Should throw an Exception");
        }
        catch (NoSuchElementException e) {
            long totalTime = System.currentTimeMillis() - startTime;
            PooledJavaComponentTestCase.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        }
    }

    public void testBlockOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = this.createPooledComponent(pp);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        int oneRemainingInPool = 2;
        for (int i = 0; i < oneRemainingInPool; ++i) {
            LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
            PooledJavaComponentTestCase.assertEquals((int)component.lifecycleAdapterPool.getNumActive(), (int)(i + 1));
        }
        PooledJavaComponentTestCase.assertEquals((int)oneRemainingInPool, (int)component.lifecycleAdapterPool.getNumActive());
        long startTime = System.currentTimeMillis();
        int borrowerWait = 500;
        Borrower borrower = new Borrower(component, borrowerWait);
        new Thread((Runnable)borrower, "BorrowThread").start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        long totalTime = System.currentTimeMillis() - startTime;
        PooledJavaComponentTestCase.assertTrue((totalTime >= (long)borrowerWait ? 1 : 0) != 0);
    }

    public void testGrowOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(2);
        PooledJavaComponent component = this.createPooledComponent(pp);
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)4, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testClearPool() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = this.createPooledComponent(pp);
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        component.stop();
        component.start();
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testObjectUniqueness() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(UniqueComponent.class);
        PooledJavaComponent component = this.createPooledComponent((ObjectFactory)objectFactory);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        String id1 = this.getIdFromObjectCreatedByPool(component);
        String id2 = this.getIdFromObjectCreatedByPool(component);
        String id3 = this.getIdFromObjectCreatedByPool(component);
        PooledJavaComponentTestCase.assertFalse((String)("Service IDs " + id1 + " and " + id2 + " should be different"), (boolean)id1.equals(id2));
        PooledJavaComponentTestCase.assertFalse((String)("Service IDs " + id2 + " and " + id3 + " should be different"), (boolean)id2.equals(id3));
        PooledJavaComponentTestCase.assertFalse((String)("Service IDs " + id1 + " and " + id3 + " should be different"), (boolean)id1.equals(id3));
    }

    public void testDisposingFactoryDisposesObject() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(WaterMelon.class);
        PooledJavaComponent component = this.createPooledComponent((ObjectFactory)objectFactory);
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.stop();
        component.dispose();
        PooledJavaComponentTestCase.assertNull((Object)lifecycleAdapter.componentObject);
    }

    private PrototypeObjectFactory getDefaultObjectFactory() throws InitialisationException {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.initialise();
        return objectFactory;
    }

    private PooledJavaComponent createPooledComponent() throws Exception {
        return this.createPooledComponent(this.createDefaultPoolingProfile(), (ObjectFactory)this.getDefaultObjectFactory());
    }

    private PooledJavaComponent createPooledComponent(ObjectFactory objectFactory) throws Exception {
        return this.createPooledComponent(this.createDefaultPoolingProfile(), objectFactory);
    }

    private PooledJavaComponent createPooledComponent(PoolingProfile poolingProfile) throws Exception {
        return this.createPooledComponent(poolingProfile, (ObjectFactory)this.getDefaultObjectFactory());
    }

    private PooledJavaComponent createPooledComponent(PoolingProfile poolingProfile, ObjectFactory objectFactory) throws Exception {
        PooledJavaComponent component = new PooledJavaComponent(objectFactory, poolingProfile);
        component.setMuleContext(muleContext);
        component.setFlowConstruct((FlowConstruct)PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        return component;
    }

    private void borrowLifecycleAdaptersUntilPoolIsFull(PooledJavaComponent component) throws Exception {
        for (int i = 0; i < 3; ++i) {
            LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
            PooledJavaComponentTestCase.assertEquals((int)component.lifecycleAdapterPool.getNumActive(), (int)(i + 1));
        }
        PooledJavaComponentTestCase.assertEquals((int)3, (int)component.lifecycleAdapterPool.getNumActive());
    }

    private String getIdFromObjectCreatedByPool(PooledJavaComponent component) throws Exception {
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        Object obj = lifecycleAdapter.componentObject;
        PooledJavaComponentTestCase.assertNotNull((Object)obj);
        PooledJavaComponentTestCase.assertTrue((String)"Object should be of type UniqueComponent", (boolean)(obj instanceof UniqueComponent));
        String id = ((UniqueComponent)obj).getId();
        PooledJavaComponentTestCase.assertNotNull((Object)id);
        return id;
    }

    private static class Borrower
    implements Runnable {
        private PooledJavaComponent component;
        private long time;

        public Borrower(PooledJavaComponent component, long time) {
            if (component == null) {
                throw new IllegalArgumentException("Pool cannot be null");
            }
            this.component = component;
            if (time < 500L) {
                time = 500L;
            }
            this.time = time;
        }

        public void run() {
            try {
                LifecycleAdapter object = this.component.borrowComponentLifecycleAdaptor();
                try {
                    Thread.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.component.returnComponentLifecycleAdaptor(object);
            }
            catch (Exception e) {
                Assert.fail((String)("Borrower thread failed:\n" + ExceptionUtils.getStackTrace((Throwable)e)));
            }
        }
    }
}

