/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractMuleTestCase;

public class ExceptionsTestCase
extends AbstractMuleTestCase {
    public void testExceptionChaining() {
        String rootMsg = "Root Test Exception Message";
        String msg = "Test Exception Message";
        MuleContextException e = new MuleContextException(MessageFactory.createStaticMessage((String)msg), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)rootMsg)));
        ExceptionsTestCase.assertEquals((String)rootMsg, (String)e.getCause().getMessage());
        ExceptionsTestCase.assertEquals((String)msg, (String)e.getMessage());
        ExceptionsTestCase.assertEquals((String)(e.getClass().getName() + ": " + msg), (String)e.toString());
    }

    public final void testRoutingExceptionNullMessageValidEndpoint() throws MuleException {
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("test://outbound");
        ExceptionsTestCase.assertNotNull((Object)endpoint);
        RoutingException rex = new RoutingException((MuleEvent)null, (MessageProcessor)endpoint);
        ExceptionsTestCase.assertSame((Object)endpoint, (Object)rex.getRoute());
    }
}

