/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.cache.TempJarCache;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import jogamp.common.Debug;
import jogamp.common.jvm.JVMUtil;
import jogamp.common.os.MachineDescriptionRuntime;
import jogamp.common.os.PlatformPropsImpl;

public class Platform
extends PlatformPropsImpl {
    private static final String useTempJarCachePropName = "jogamp.gluegen.UseTempJarCache";
    private static final String libBaseName = "gluegen-rt";
    public static final boolean USE_TEMP_JAR_CACHE;
    private static final MachineDescription machineDescription;
    private static final boolean is32Bit;
    public static final boolean AWT_AVAILABLE;
    private static final URL platformClassJarURL;

    private Platform() {
    }

    public static final boolean isRunningFromJarURL() {
        return null != platformClassJarURL;
    }

    private static final void loadGlueGenRTImpl() {
        if (USE_TEMP_JAR_CACHE && TempJarCache.initSingleton()) {
            String string = null;
            URL uRL = null;
            URL uRL2 = null;
            try {
                String string2 = JarUtil.getJarBasename(platformClassJarURL);
                String string3 = string2.substring(0, string2.indexOf(".jar"));
                string = string3 + "-natives-" + PlatformPropsImpl.os_and_arch + ".jar";
                uRL = JarUtil.getURLDirname(JarUtil.getJarSubURL(platformClassJarURL));
                uRL2 = JarUtil.getJarFileURL(uRL, string);
                TempJarCache.bootstrapNativeLib(Platform.class, libBaseName, uRL2);
            }
            catch (Exception exception) {
                System.err.println("Catched " + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ", while TempJarCache.bootstrapNativeLib() of " + uRL2 + " (" + uRL + " + " + string + ")");
            }
        }
        DynamicLibraryBundle.GlueJNILibLoader.loadLibrary(libBaseName, false, Platform.class.getClassLoader());
    }

    public static void initSingleton() {
    }

    public static boolean isJavaSE() {
        return JAVA_SE;
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOSName() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static VersionNumber getOSVersionNumber() {
        return OS_VERSION_NUMBER;
    }

    public static String getArchName() {
        return ARCH;
    }

    public static OSType getOSType() {
        return OS_TYPE;
    }

    public static CPUFamily getCPUFamily() {
        return CPU_ARCH.getFamily();
    }

    public static CPUType getCPUType() {
        return CPU_ARCH;
    }

    public static ABIType getABIType() {
        return ABI_TYPE;
    }

    public static String getOSAndArch() {
        return os_and_arch;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVMName() {
        return JAVA_VM_NAME;
    }

    public static String getJavaRuntimeName() {
        return JAVA_RUNTIME_NAME;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static VersionNumber getJavaVersionNumber() {
        return JAVA_VERSION_NUMBER;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static boolean is32Bit() {
        return is32Bit;
    }

    public static boolean is64Bit() {
        return !is32Bit;
    }

    public static MachineDescription getMachineDescription() {
        return machineDescription;
    }

    public static boolean isAWTAvailable() {
        return AWT_AVAILABLE;
    }

    public static synchronized long getCurrentSleepJitter() {
        Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
        return Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
    }

    private static long getCurrentSleepJitterImpl(long l, int n) {
        long l2 = l / (long)n;
        long l3 = System.nanoTime();
        for (int i = n; i > 0; --i) {
            try {
                TimeUnit.NANOSECONDS.sleep(l2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (System.nanoTime() - l3 - l) / (long)n;
    }

    static {
        Object object;
        PlatformPropsImpl.initSingleton();
        try {
            object = JarUtil.getJarURL(Platform.class.getName(), Platform.class.getClassLoader());
        }
        catch (Exception exception) {
            object = null;
        }
        platformClassJarURL = object;
        USE_TEMP_JAR_CACHE = OS_TYPE != OSType.ANDROID && Platform.isRunningFromJarURL() && Debug.getBooleanProperty(useTempJarCachePropName, true, true);
        AWT_AVAILABLE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Platform.loadGlueGenRTImpl();
                JVMUtil.initSingleton();
                boolean bl = false;
                ClassLoader classLoader = Platform.class.getClassLoader();
                if (!Debug.getBooleanProperty("java.awt.headless", true) && ReflectionUtil.isClassAvailable("java.awt.Component", classLoader) && ReflectionUtil.isClassAvailable("java.awt.GraphicsEnvironment", classLoader)) {
                    try {
                        bl = false == (Boolean)ReflectionUtil.callStaticMethod("java.awt.GraphicsEnvironment", "isHeadless", null, null, classLoader);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return new Boolean(bl);
            }
        });
        object = MachineDescriptionRuntime.getRuntime();
        if (null == object) {
            MachineDescription.StaticConfig staticConfig = MachineDescriptionRuntime.getStatic();
            object = staticConfig.md;
            System.err.println("Warning: Using static MachineDescription: " + (Object)((Object)staticConfig));
        } else {
            MachineDescription.StaticConfig staticConfig = MachineDescriptionRuntime.getStatic();
            if (!((MachineDescription)object).compatible(staticConfig.md)) {
                throw new RuntimeException("Incompatible MachineDescriptions:" + PlatformPropsImpl.NEWLINE + " Static " + (Object)((Object)staticConfig) + PlatformPropsImpl.NEWLINE + " Runtime " + object);
            }
        }
        machineDescription = object;
        is32Bit = machineDescription.is32Bit();
    }

    public static enum ABIType {
        GENERIC_ABI(0),
        EABI_GNU_ARMEL(1),
        EABI_GNU_ARMHF(2);

        public final int id;

        private ABIType(int n2) {
            this.id = n2;
        }
    }

    public static enum CPUType {
        X86_32(CPUFamily.X86, 1),
        X86_64(CPUFamily.X86, 2),
        ARM(CPUFamily.ARM, 0),
        ARMv5(CPUFamily.ARM, 1),
        ARMv6(CPUFamily.ARM, 2),
        ARMv7(CPUFamily.ARM, 4),
        PPC(CPUFamily.PPC, 0),
        SPARC_32(CPUFamily.SPARC, 1),
        SPARCV9_64(CPUFamily.SPARC, 2),
        IA64(CPUFamily.IA64, 0),
        PA_RISC2_0(CPUFamily.PA_RISC, 1);

        public final int id;
        public final CPUFamily family;

        private CPUType(CPUFamily cPUFamily, int n2) {
            this.family = cPUFamily;
            this.id = n2;
        }

        public CPUFamily getFamily() {
            return this.family;
        }
    }

    public static enum CPUFamily {
        X86(0),
        ARM(65536),
        PPC(131072),
        SPARC(196608),
        PA_RISC(-65536),
        IA64(-61440);

        public final int id;

        private CPUFamily(int n2) {
            this.id = n2;
        }
    }

    public static enum OSType {
        LINUX(0),
        FREEBSD(1),
        ANDROID(2),
        MACOS(3),
        SUNOS(4),
        HPUX(5),
        WINDOWS(6),
        OPENKODE(7);

        public final int id;

        private OSType(int n2) {
            this.id = n2;
        }
    }
}

