/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.mavenreport;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public class SonarReportMojo
extends AbstractMavenReport {
    private String sonarHostURL;
    private File outputDirectory;
    protected Renderer siteRenderer;
    protected MavenProject project;
    private String branch;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(this.getBundle(locale).getString("report.sonar.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.sectionTitle1();
        sink.text(this.getBundle(locale).getString("report.sonar.header"));
        sink.sectionTitle1_();
        String url = this.getProjectUrl();
        sink.text("Redirecting to ");
        sink.link(url);
        sink.text(url);
        sink.link_();
        sink.rawText("<script type='text/javascript'> window.location='" + url + "'</script>");
        sink.body_();
        sink.flush();
        sink.close();
    }

    public String getOutputName() {
        return "sonar";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.sonar.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.sonar.description");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("sonar-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getProjectUrl() {
        StringBuilder sb = new StringBuilder(this.getSonarUrl()).append("/project/index/").append(this.project.getGroupId()).append(":").append(this.project.getArtifactId());
        if (this.branch != null) {
            sb.append(":").append(this.branch);
        }
        return sb.toString();
    }

    private String getSonarUrl() {
        if (this.sonarHostURL.endsWith("/")) {
            return this.sonarHostURL.substring(0, this.sonarHostURL.length() - 1);
        }
        return this.sonarHostURL;
    }
}

