/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class FileWagon
extends StreamWagon {
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to operate with a null basedir.");
        }
        Resource resource = inputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        if (!file.exists()) {
            throw new ResourceDoesNotExistException("File: " + file + " does not exist");
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            inputData.setInputStream((InputStream)in);
            resource.setContentLength(file.length());
            resource.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException("Could not read from file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to operate with a null basedir.");
        }
        Resource resource = outputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        this.createParentDirectories(file);
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)new LazyFileOutputStream(file));
        outputData.setOutputStream((OutputStream)outputStream);
    }

    protected void openConnectionInternal() throws ConnectionException {
        if (this.getRepository() == null) {
            throw new ConnectionException("Unable to operate with a null repository.");
        }
        if (this.getRepository().getBasedir() == null) {
            this.fireSessionDebug("Using a null basedir.");
            return;
        }
        File basedir = new File(this.getRepository().getBasedir());
        if (!basedir.exists() && !basedir.mkdirs()) {
            throw new ConnectionException("Repository path " + basedir + " does not exist, and cannot be created.");
        }
        if (!basedir.canRead()) {
            throw new ConnectionException("Repository path " + basedir + " cannot be read");
        }
    }

    public void closeConnection() {
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to putDirectory() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        try {
            File realFile = path.getCanonicalFile();
            realFile.mkdirs();
        }
        catch (IOException e) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            String emsg = "Could not make directory '" + path.getAbsolutePath() + "'.";
            File basedir = new File(this.getRepository().getBasedir());
            if (!basedir.canWrite()) {
                emsg = emsg + "  The base directory " + basedir + " is read-only.";
            }
            throw new TransferFailedException(emsg);
        }
        try {
            FileUtils.copyDirectoryStructure((File)sourceDirectory, (File)path);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error copying directory structure", (Throwable)e);
        }
    }

    private File resolveDestinationPath(String destinationPath) {
        String basedir = this.getRepository().getBasedir();
        File path = (destinationPath = StringUtils.replace((String)destinationPath, (String)"\\", (String)"/")).equals(".") ? new File(basedir) : new File(basedir, destinationPath);
        return path;
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to getFileList() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        if (!path.exists()) {
            throw new ResourceDoesNotExistException("Directory does not exist: " + destinationDirectory);
        }
        if (!path.isDirectory()) {
            throw new ResourceDoesNotExistException("Path is not a directory: " + destinationDirectory);
        }
        String[] files = path.list();
        return Arrays.asList(files);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to getFileList() with a null basedir.");
        }
        File file = this.resolveDestinationPath(resourceName);
        return file.exists();
    }
}

