/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.surefire.report.AbstractConsoleReporter;
import org.apache.maven.plugin.surefire.report.AbstractFileReporter;
import org.apache.maven.plugin.surefire.report.MulticastingReporter;
import org.apache.maven.plugin.surefire.report.Reporter;
import org.apache.maven.plugin.surefire.report.XMLReporter;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.TestSetStatistics;
import org.apache.maven.surefire.util.internal.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSetRunListener
implements RunListener,
Reporter,
ConsoleOutputReceiver,
ConsoleLogger {
    private final TestSetStatistics testSetStatistics;
    private final RunStatistics globalStatistics;
    private final MulticastingReporter multicastingReporter;
    private final List<ByteBuffer> testStdOut = Collections.synchronizedList(new ArrayList());
    private final List<ByteBuffer> testStdErr = Collections.synchronizedList(new ArrayList());

    public TestSetRunListener(AbstractConsoleReporter consoleReporter, AbstractFileReporter fileReporter, XMLReporter xmlReporter, Reporter reporter, StatisticsReporter statisticsReporter, RunStatistics globalStats) {
        ArrayList<Reporter> reporters = new ArrayList<Reporter>();
        if (consoleReporter != null) {
            reporters.add(consoleReporter);
        }
        if (fileReporter != null) {
            reporters.add(fileReporter);
        }
        if (xmlReporter != null) {
            reporters.add(xmlReporter);
        }
        if (reporter != null) {
            reporters.add(reporter);
        }
        if (statisticsReporter != null) {
            reporters.add(statisticsReporter);
        }
        this.multicastingReporter = new MulticastingReporter(reporters);
        this.testSetStatistics = new TestSetStatistics();
        this.globalStatistics = globalStats;
    }

    public void info(String message) {
        this.multicastingReporter.writeMessage(message);
    }

    @Override
    public void writeMessage(String message) {
        this.info(message);
    }

    @Override
    public void writeMessage(byte[] b, int off, int len) {
        this.multicastingReporter.writeMessage(b, off, len);
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        ByteBuffer byteBuffer = new ByteBuffer(buf, off, len);
        if (stdout) {
            this.testStdOut.add(byteBuffer);
        } else {
            this.testStdErr.add(byteBuffer);
        }
        this.multicastingReporter.writeMessage(buf, off, len);
    }

    @Override
    public void testSetStarting(ReportEntry report) {
        this.multicastingReporter.testSetStarting(report);
    }

    public void clearCapture() {
        this.testStdErr.clear();
        this.testStdOut.clear();
    }

    @Override
    public void testSetCompleted(ReportEntry report) {
        this.multicastingReporter.testSetCompleted(report);
        this.multicastingReporter.reset();
        this.globalStatistics.add(this.testSetStatistics);
        this.testSetStatistics.reset();
    }

    @Override
    public void testStarting(ReportEntry report) {
        this.multicastingReporter.testStarting(report);
    }

    @Override
    public void testSucceeded(ReportEntry report) {
        this.testSetStatistics.incrementCompletedCount();
        this.multicastingReporter.testSucceeded(report);
        this.clearCapture();
    }

    public void testError(ReportEntry reportEntry) {
        this.multicastingReporter.testError(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
        this.testSetStatistics.incrementErrorsCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addErrorSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    @Override
    public void testError(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testError(reportEntry, stdOutLog, stdErrLog);
        this.testSetStatistics.incrementErrorsCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addErrorSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    public void testFailed(ReportEntry reportEntry) {
        this.multicastingReporter.testFailed(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
        this.testSetStatistics.incrementFailureCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addFailureSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    @Override
    public void testFailed(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testFailed(reportEntry, stdOutLog, stdErrLog);
        this.testSetStatistics.incrementFailureCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addFailureSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    @Override
    public void testSkipped(ReportEntry report) {
        this.clearCapture();
        this.testSetStatistics.incrementSkippedCount();
        this.testSetStatistics.incrementCompletedCount();
        this.multicastingReporter.testSkipped(report);
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.testSkipped(report);
    }

    @Override
    public void reset() {
        this.multicastingReporter.reset();
    }

    public String getAsString(List<ByteBuffer> byteBufferList) {
        StringBuilder stringBuffer = new StringBuilder();
        for (ByteBuffer byteBuffer : byteBufferList) {
            stringBuffer.append(byteBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

