/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.diff;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.diff.StarteamDiffConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamDiffCommand
extends AbstractDiffCommand
implements StarteamCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support diff command on a subsets of a directory");
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamDiffConsumer consumer = new StarteamDiffConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = StarteamDiffCommand.createCommandLine(repository, fileSet.getBasedir(), startRevision, endRevision);
        int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new DiffScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File workingDirectory, String startLabel, String endLabel) throws ScmException {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("diff", workingDirectory, repo);
        cl.createArgument().setValue("-is");
        cl.createArgument().setValue("-filter");
        cl.createArgument().setValue("M");
        if (startLabel != null && startLabel.length() != 0) {
            cl.createArgument().setValue("-vl");
            cl.createArgument().setValue(startLabel);
        }
        if (endLabel != null && endLabel.length() != 0) {
            cl.createArgument().setValue("-vl");
            cl.createArgument().setValue(endLabel);
        }
        if (endLabel != null && (startLabel == null || startLabel.length() == 0)) {
            throw new ScmException("Missing start label.");
        }
        return cl;
    }
}

