/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceInfoCommand
extends AbstractCommand
implements PerforceCommand {
    private static PerforceInfoCommand singleton = null;
    private Map<String, String> entries = null;

    public static PerforceInfoCommand getInfo(ScmLogger logger, PerforceScmProviderRepository repo) {
        return PerforceInfoCommand.getSingleton(logger, repo);
    }

    public String getEntry(String key) {
        return this.entries.get(key);
    }

    private static synchronized PerforceInfoCommand getSingleton(ScmLogger logger, PerforceScmProviderRepository repo) {
        block4: {
            if (singleton == null) {
                PerforceInfoCommand pic = new PerforceInfoCommand();
                if (logger != null) {
                    pic.setLogger(logger);
                }
                try {
                    pic.executeCommand((ScmProviderRepository)repo, null, null);
                    singleton = pic;
                }
                catch (ScmException e) {
                    if (!pic.getLogger().isErrorEnabled()) break block4;
                    pic.getLogger().error("ScmException " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return singleton;
    }

    protected ScmResult executeCommand(ScmProviderRepository repo, ScmFileSet scmFileSet, CommandParameters commandParameters) throws ScmException {
        if (!PerforceScmProvider.isLive()) {
            return null;
        }
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command((PerforceScmProviderRepository)repo, null);
            command.createArg().setValue("info");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(PerforceScmProvider.clean("Executing: " + command.toString()));
            }
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            this.entries = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(58);
                if (idx == -1) {
                    if (line.indexOf("Client unknown.") == -1) {
                        throw new IllegalStateException("Unexpected results from 'p4 info' command: " + line);
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Cannot find client.");
                    }
                    this.entries.put("Client root", "");
                    continue;
                }
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1).trim();
                this.entries.put(key, value);
            }
        }
        catch (CommandLineException e) {
            throw new ScmException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ScmException(e.getLocalizedMessage());
        }
        return null;
    }
}

