/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.unedit;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceUnEditConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String PATTERN = "^([^#]+)#\\d+ - (.*)";
    private static final int STATE_NORMAL = 1;
    private static final int STATE_ERROR = 2;
    private int currentState = 1;
    private List edits = new ArrayList();
    private RE revisionRegexp;

    public PerforceUnEditConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List getEdits() {
        return this.edits;
    }

    public void consumeLine(String line) {
        if (this.currentState != 2 && this.revisionRegexp.match(line)) {
            this.edits.add(this.revisionRegexp.getParen(1));
            return;
        }
        this.error(line);
    }

    private void error(String line) {
        this.currentState = 2;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 1;
    }
}

