/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.remove;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.remove.PerforceRemoveConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceRemoveCommand
extends AbstractRemoveCommand
implements PerforceCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet files, String message) throws ScmException {
        Commandline cl = PerforceRemoveCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
        PerforceRemoveConsumer consumer = new PerforceRemoveConsumer();
        try {
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovals());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("delete");
        try {
            String candir = workingDirectory.getCanonicalPath();
            File[] fs = files.getFiles();
            for (int i = 0; i < fs.length; ++i) {
                File file = fs[i];
                String canfile = file.getCanonicalPath();
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                command.createArgument().setValue(file.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return command;
    }
}

