/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceCheckOutCommand
extends AbstractCheckOutCommand
implements PerforceCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, String tag) throws ScmException {
        CheckOutScmResult checkOutScmResult;
        boolean clientspecExists;
        Commandline cl;
        PerforceCheckOutConsumer consumer;
        String specname;
        File workingDirectory;
        PerforceScmProviderRepository prepo;
        block28: {
            prepo = (PerforceScmProviderRepository)repo;
            workingDirectory = new File(files.getBasedir().getAbsolutePath());
            specname = PerforceScmProvider.getClientspecName(prepo, workingDirectory);
            consumer = new PerforceCheckOutConsumer(specname, prepo.getPath());
            this.getLogger().info("Checkout working directory: " + workingDirectory);
            cl = null;
            try {
                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                cl.createArgument().setValue("client");
                cl.createArgument().setValue("-i");
                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                Process proc = cl.execute();
                OutputStream out = proc.getOutputStream();
                DataOutputStream dos = new DataOutputStream(out);
                String client = PerforceScmProvider.createClientspec(prepo, specname, workingDirectory);
                this.getLogger().debug("Updating clientspec:\n" + client);
                dos.write(client.getBytes());
                dos.close();
                out.close();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.getLogger().debug("Consuming: " + line);
                    consumer.consumeLine(line);
                }
                br.close();
            }
            catch (IOException e) {
                this.getLogger().error((Throwable)e);
            }
            catch (CommandLineException e) {
                this.getLogger().error((Throwable)e);
            }
            clientspecExists = consumer.isSuccess();
            if (clientspecExists) {
                try {
                    cl = PerforceCheckOutCommand.createCommandLine(prepo, workingDirectory, tag, specname);
                    this.getLogger().debug("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    Process proc = cl.execute();
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        this.getLogger().debug("Consuming: " + line);
                        consumer.consumeLine(line);
                    }
                    br.close();
                    this.getLogger().debug("Perforce sync complete.");
                }
                catch (IOException e) {
                    this.getLogger().error((Throwable)e);
                }
                catch (CommandLineException e) {
                    this.getLogger().error((Throwable)e);
                }
            }
            if (!consumer.isSuccess()) break block28;
            checkOutScmResult = new CheckOutScmResult(cl.toString(), consumer.getCheckedout());
            Object var16_20 = null;
            if (clientspecExists && !prepo.isPersistCheckout()) {
                try {
                    cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                    cl.createArgument().setValue("client");
                    cl.createArgument().setValue("-d");
                    cl.createArgument().setValue(specname);
                    this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    Process proc = cl.execute();
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        this.getLogger().debug("Consuming: " + line);
                        consumer.consumeLine(line);
                    }
                    br.close();
                }
                catch (CommandLineException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            } else if (clientspecExists) {
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
            return checkOutScmResult;
        }
        try {
            checkOutScmResult = new CheckOutScmResult(cl.toString(), "Unable to sync.  Are you logged in?", consumer.getOutput(), consumer.isSuccess());
            Object var16_21 = null;
        }
        catch (Throwable throwable) {
            block30: {
                block29: {
                    Object var16_22 = null;
                    if (!clientspecExists || prepo.isPersistCheckout()) break block29;
                    try {
                        cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                        cl.createArgument().setValue("client");
                        cl.createArgument().setValue("-d");
                        cl.createArgument().setValue(specname);
                        this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                        Process proc = cl.execute();
                        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            this.getLogger().debug("Consuming: " + line);
                            consumer.consumeLine(line);
                        }
                        br.close();
                    }
                    catch (CommandLineException e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    break block30;
                }
                if (!clientspecExists) break block30;
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
            throw throwable;
        }
        if (clientspecExists && !prepo.isPersistCheckout()) {
            try {
                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                cl.createArgument().setValue("client");
                cl.createArgument().setValue("-d");
                cl.createArgument().setValue(specname);
                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                Process proc = cl.execute();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.getLogger().debug("Consuming: " + line);
                    consumer.consumeLine(line);
                }
                br.close();
            }
            catch (CommandLineException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        } else if (clientspecExists) {
            System.setProperty("maven.scm.perforce.clientspec.name", specname);
        }
        return checkOutScmResult;
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String tag, String specname) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("-c" + specname);
        command.createArgument().setValue("sync");
        String[] files = workingDirectory.list();
        if (files == null || files.length == 0) {
            command.createArgument().setValue("-f");
        }
        if (tag != null) {
            command.createArgument().setValue("@" + tag);
        }
        return command;
    }
}

