/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.add;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.add.PerforceAddConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceAddCommand
extends AbstractAddCommand
implements PerforceCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet files, String message, boolean binary) throws ScmException {
        Commandline cl = PerforceAddCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
        PerforceAddConsumer consumer = new PerforceAddConsumer();
        try {
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return new AddScmResult(cl.toString(), consumer.getAdditions());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("add");
        try {
            String candir = workingDirectory.getCanonicalPath();
            File[] fs = files.getFiles();
            for (int i = 0; i < fs.length; ++i) {
                File file = fs[i];
                String canfile = file.getCanonicalPath();
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                command.createArgument().setValue(file.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return command;
    }
}

