/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.command.add.PerforceAddCommand;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceChangeLogCommand;
import org.apache.maven.scm.provider.perforce.command.checkin.PerforceCheckInCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutCommand;
import org.apache.maven.scm.provider.perforce.command.diff.PerforceDiffCommand;
import org.apache.maven.scm.provider.perforce.command.edit.PerforceEditCommand;
import org.apache.maven.scm.provider.perforce.command.login.PerforceLoginCommand;
import org.apache.maven.scm.provider.perforce.command.remove.PerforceRemoveCommand;
import org.apache.maven.scm.provider.perforce.command.status.PerforceStatusCommand;
import org.apache.maven.scm.provider.perforce.command.tag.PerforceTagCommand;
import org.apache.maven.scm.provider.perforce.command.unedit.PerforceUnEditCommand;
import org.apache.maven.scm.provider.perforce.command.update.PerforceUpdateCommand;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceScmProvider
extends AbstractScmProvider {
    private static final String NEWLINE = "\r\n";
    public static final String DEFAULT_CLIENTSPEC_PROPERTY = "maven.scm.perforce.clientspec.name";

    public boolean requiresEditMode() {
        return true;
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        String path;
        int port = 0;
        String host = null;
        int i1 = scmSpecificUrl.indexOf(delimiter);
        int i2 = scmSpecificUrl.indexOf(delimiter, i1 + 1);
        if (i1 > 0) {
            int lastDelimiter = scmSpecificUrl.lastIndexOf(delimiter);
            path = scmSpecificUrl.substring(lastDelimiter + 1);
            host = scmSpecificUrl.substring(0, i1);
            if (i2 >= 0) {
                try {
                    String tmp = scmSpecificUrl.substring(i1 + 1, lastDelimiter);
                    port = Integer.parseInt(tmp);
                }
                catch (NumberFormatException ex) {
                    throw new ScmRepositoryException("The port has to be a number.");
                }
            }
        } else {
            path = scmSpecificUrl;
        }
        String user = null;
        String password = null;
        if (host != null && host.indexOf("@") > 1) {
            user = host.substring(0, host.indexOf("@"));
            host = host.substring(host.indexOf("@") + 1);
        }
        if (path.indexOf("@") > 1) {
            if (host != null) {
                this.getLogger().warn("Username as part of path is deprecated, the new format is scm:perforce:[username@]host:port:path_to_repository");
            }
            user = path.substring(0, path.indexOf("@"));
            path = path.substring(path.indexOf("@") + 1);
        }
        return new PerforceScmProviderRepository(host, port, path, user, password);
    }

    public String getScmType() {
        return "perforce";
    }

    protected ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        PerforceChangeLogCommand command = new PerforceChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    protected AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceAddCommand command = new PerforceAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceRemoveCommand command = new PerforceRemoveCommand();
        command.setLogger(this.getLogger());
        return (RemoveScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceCheckInCommand command = new PerforceCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceCheckOutCommand command = new PerforceCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceDiffCommand command = new PerforceDiffCommand();
        command.setLogger(this.getLogger());
        return (DiffScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected EditScmResult edit(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceEditCommand command = new PerforceEditCommand();
        command.setLogger(this.getLogger());
        return (EditScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected LoginScmResult login(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceLoginCommand command = new PerforceLoginCommand();
        command.setLogger(this.getLogger());
        return (LoginScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceStatusCommand command = new PerforceStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceTagCommand command = new PerforceTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected UnEditScmResult unedit(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceUnEditCommand command = new PerforceUnEditCommand();
        command.setLogger(this.getLogger());
        return (UnEditScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    protected UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        PerforceUpdateCommand command = new PerforceUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.execute(repository.getProviderRepository(), fileSet, params);
    }

    public static Commandline createP4Command(PerforceScmProviderRepository repo, File workingDir) {
        Commandline command = new Commandline();
        command.setExecutable("p4");
        command.setWorkingDirectory(workingDir.getAbsolutePath());
        if (repo.getHost() != null) {
            command.createArgument().setValue("-H");
            String value = repo.getHost();
            if (repo.getPort() != 0) {
                value = value + ":" + Integer.toString(repo.getPort());
            }
            command.createArgument().setValue(value);
        }
        if (StringUtils.isNotEmpty((String)repo.getUser())) {
            command.createArgument().setValue("-u");
            command.createArgument().setValue(repo.getUser());
        }
        if (StringUtils.isNotEmpty((String)repo.getPassword())) {
            command.createArgument().setValue("-P");
            command.createArgument().setValue(repo.getPassword());
        }
        return command;
    }

    public static String clean(String string) {
        if (string.indexOf(" -P ") == -1) {
            return string;
        }
        int idx = string.indexOf(" -P ") + 4;
        int end = string.indexOf(32, idx);
        return string.substring(0, idx) + StringUtils.repeat((String)"*", (int)(end - idx)) + string.substring(end);
    }

    public static String getCanonicalRepoPath(String repoPath) {
        if (repoPath.endsWith("/...")) {
            return repoPath;
        }
        if (repoPath.endsWith("/")) {
            return repoPath + "...";
        }
        return repoPath + "/...";
    }

    public static String createClientspec(PerforceScmProviderRepository repo, String specname, File workDir) {
        String clientspecName = PerforceScmProvider.getClientspecName(repo, workDir);
        String userName = PerforceScmProvider.getUsername(repo);
        StringBuffer buf = new StringBuffer();
        buf.append("Client: ").append(clientspecName).append(NEWLINE);
        buf.append("Root: ").append(workDir).append(NEWLINE);
        buf.append("Owner: ").append(userName).append(NEWLINE);
        buf.append("View:").append(NEWLINE);
        buf.append("\t").append(PerforceScmProvider.getCanonicalRepoPath(repo.getPath()));
        buf.append(" //").append(clientspecName).append("/...").append(NEWLINE);
        buf.append("Description:").append(NEWLINE);
        buf.append("\t").append("Created by maven-scm-provider-perforce").append(NEWLINE);
        return buf.toString();
    }

    public static String getClientspecName(PerforceScmProviderRepository repo, File workDir) {
        String clientspecName = System.getProperty(DEFAULT_CLIENTSPEC_PROPERTY, PerforceScmProvider.generateDefaultClientspecName(repo, workDir));
        return clientspecName;
    }

    private static String generateDefaultClientspecName(PerforceScmProviderRepository repo, File workDir) {
        String username = PerforceScmProvider.getUsername(repo);
        String hostname = "nohost";
        String path = "nopath";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            path = workDir.getCanonicalPath();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return username + "-" + hostname + "-MavenSCM-" + path;
    }

    private static String getUsername(PerforceScmProviderRepository repo) {
        String username = repo.getUser();
        if (username == null) {
            username = System.getProperty("user.name", "nouser");
        }
        return username;
    }
}

