/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.StringUtils;

public class GitUpdateCommandConsumer
extends AbstractConsumer {
    private boolean updatingFound;
    private boolean summaryFound;
    private Map scmFiles = new LinkedHashMap();

    public GitUpdateCommandConsumer(ScmLogger logger, File workingDirectory) {
        super(logger);
    }

    public void consumeLine(String line) {
        String[] changedFileLine;
        this.getLogger().debug("GitUpdateCommandConsumer consumeLine : " + line);
        if (line == null || StringUtils.isEmpty((String)line)) {
            return;
        }
        if (!this.updatingFound && line.startsWith("Updating")) {
            this.updatingFound = true;
            return;
        }
        if (line.indexOf("files changed") >= 0) {
            this.summaryFound = true;
            return;
        }
        if (this.updatingFound && !this.summaryFound) {
            int index = line.indexOf("\u2190[");
            if (index >= 0) {
                String fileName = StringUtils.trim((String)line.substring(0, index));
                this.scmFiles.put(fileName, new ScmFile(fileName, ScmFileStatus.UPDATED));
                return;
            }
            index = line.indexOf("|");
            if (index >= 0) {
                String fileName = StringUtils.trim((String)line.substring(0, index));
                this.scmFiles.put(fileName, new ScmFile(fileName, ScmFileStatus.UPDATED));
                return;
            }
        }
        if (this.updatingFound && this.summaryFound && (changedFileLine = StringUtils.split((String)line, (String)" ")) != null && changedFileLine.length >= 4) {
            String status = changedFileLine[0];
            String fileName = changedFileLine[3];
            ScmFile scmFile = (ScmFile)this.scmFiles.get(fileName);
            if (scmFile != null) {
                if (StringUtils.equalsIgnoreCase((String)"delete", (String)status)) {
                    this.scmFiles.put(fileName, new ScmFile(fileName, ScmFileStatus.DELETED));
                }
                if (StringUtils.equalsIgnoreCase((String)"create", (String)status)) {
                    this.scmFiles.put(fileName, new ScmFile(fileName, ScmFileStatus.ADDED));
                }
            }
        }
    }

    public List getUpdatedFiles() {
        this.getLogger().debug(" updatedFiles size " + this.scmFiles.size());
        return new ArrayList(this.scmFiles.values());
    }
}

