/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.edit;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.edit.ClearCaseEditConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseEditCommand
extends AbstractEditCommand
implements ClearCaseCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing edit command...");
        Commandline cl = ClearCaseEditCommand.createCommandLine(this.getLogger(), fileSet);
        ClearCaseEditConsumer consumer = new ClearCaseEditConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new EditScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new EditScmResult(cl.toString(), consumer.getEditFiles());
    }

    public static Commandline createCommandLine(ScmLogger logger, ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("co");
        command.createArgument().setValue("-nc");
        File[] files = scmFileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            logger.info("Checking out file: " + file.getAbsolutePath());
            command.createArgument().setValue(file.getAbsolutePath());
        }
        return command;
    }

    public static Commandline createCheckoutCurrentDirCommandLine(ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("co");
        command.createArgument().setValue("-nc");
        command.createArgument().setValue(".");
        return command;
    }

    public static Commandline createCheckinCurrentDirCommandLine(ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("ci");
        command.createArgument().setValue("-nc");
        command.createArgument().setValue(".");
        return command;
    }
}

