/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-surefire-report-plugin:2.11", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Surefire Report Plugin", 0);
        this.append(sb, "Surefire is a test framework project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "failsafe-report-only".equals(this.goal)) {
            this.append(sb, "surefire-report:failsafe-report-only", 0);
            this.append(sb, "Creates a nicely formatted Failsafe Test Report in html format. This goal does not run the tests, it only builds the reports. See http://jira.codehaus.org/browse/SUREFIRE-257", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "alwaysGenerateFailsafeReport (Default: false)", 2);
                this.append(sb, "If set to true the failsafe report will be generated even when there are no failsafe result files. Defaults to false to preserve legacy behaviour pre 2.10", 3);
                this.append(sb, "Expression: ${alwaysGenerateFailsafeReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Whether to link the XRef if found.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputName (Default: failsafe-report)", 2);
                this.append(sb, "The filename to use for the report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${outputName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Maven Project", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectories", 2);
                this.append(sb, "Directories containing the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory", 2);
                this.append(sb, "(Deprecated, use reportsDirectories) This directory contains the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showSuccess (Default: true)", 2);
                this.append(sb, "If set to false, only failures are shown.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${showSuccess}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipFailsafeReport (Default: false)", 2);
                this.append(sb, "If set to true the failsafe report generation will be skipped.", 3);
                this.append(sb, "Expression: ${skipFailsafeReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Xrefs to link.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "surefire-report:help", 0);
            this.append(sb, "Display help information on maven-surefire-report-plugin.\nCall\n\u00a0\u00a0mvn\u00a0surefire-report:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "surefire-report:report", 0);
            this.append(sb, "Creates a nicely formatted Surefire Test Report in html format.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "alwaysGenerateSurefireReport (Default: true)", 2);
                this.append(sb, "If set to true the surefire report will be generated even when there are no surefire result files. Defaulyts to true to preserve legacy behaviour pre 2.10.", 3);
                this.append(sb, "Expression: ${alwaysGenerateSurefireReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Whether to link the XRef if found.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputName (Default: surefire-report)", 2);
                this.append(sb, "The filename to use for the report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${outputName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Maven Project", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectories", 2);
                this.append(sb, "Directories containing the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory", 2);
                this.append(sb, "(Deprecated, use reportsDirectories) This directory contains the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showSuccess (Default: true)", 2);
                this.append(sb, "If set to false, only failures are shown.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${showSuccess}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipSurefireReport (Default: false)", 2);
                this.append(sb, "If set to true the surefire report generation will be skipped.", 3);
                this.append(sb, "Expression: ${skipSurefireReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Xrefs to link.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report-only".equals(this.goal)) {
            this.append(sb, "surefire-report:report-only", 0);
            this.append(sb, "Creates a nicely formatted Surefire Test Report in html format. This goal does not run the tests, it only builds the reports. This is a workaround for http://jira.codehaus.org/browse/SUREFIRE-257", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "alwaysGenerateSurefireReport (Default: true)", 2);
                this.append(sb, "If set to true the surefire report will be generated even when there are no surefire result files. Defaulyts to true to preserve legacy behaviour pre 2.10.", 3);
                this.append(sb, "Expression: ${alwaysGenerateSurefireReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Whether to link the XRef if found.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputName (Default: surefire-report)", 2);
                this.append(sb, "The filename to use for the report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${outputName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Maven Project", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectories", 2);
                this.append(sb, "Directories containing the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory", 2);
                this.append(sb, "(Deprecated, use reportsDirectories) This directory contains the XML Report files that will be parsed and rendered to HTML format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showSuccess (Default: true)", 2);
                this.append(sb, "If set to false, only failures are shown.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${showSuccess}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipSurefireReport (Default: false)", 2);
                this.append(sb, "If set to true the surefire report generation will be skipped.", 3);
                this.append(sb, "Expression: ${skipSurefireReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Xrefs to link.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

