/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.SiteMojo;
import org.apache.maven.plugins.site.wagon.repository.Repository;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteStageMojo
extends SiteMojo {
    protected static final String DEFAULT_STAGING_DIRECTORY = "staging";
    protected File stagingDirectory;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String structureParentProject;
        String structureProject = SiteStageMojo.getStructure(this.project, false);
        if (structureProject == null) {
            throw new MojoExecutionException("Missing site information.");
        }
        this.stagingDirectory = this.getStagingDirectory(this.project, this.reactorProjects, this.stagingDirectory);
        this.getLog().info((CharSequence)("Using this directory for staging: " + this.stagingDirectory));
        this.outputDirectory = new File(this.stagingDirectory, structureProject);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String outputRelativePath = PathTool.getRelativePath((String)this.stagingDirectory.getAbsolutePath(), (String)new File(this.outputDirectory, "dummy.html").getAbsolutePath());
        this.project.setUrl(outputRelativePath + "/" + structureProject);
        MavenProject parent = this.siteTool.getParentProject(this.project, this.reactorProjects, this.localRepository);
        if (parent != null && (structureParentProject = SiteStageMojo.getStructure(parent, true)) != null) {
            parent.setUrl(outputRelativePath + "/" + structureParentProject);
        }
        if (this.reactorProjects != null && this.reactorProjects.size() > 1) {
            for (MavenProject reactorProject : this.reactorProjects) {
                if (reactorProject == null || reactorProject.getParent() == null || !this.project.getArtifactId().equals(reactorProject.getParent().getArtifactId())) continue;
                String structureReactorProject = SiteStageMojo.getStructure(reactorProject, false);
                reactorProject.setUrl(outputRelativePath + "/" + structureReactorProject);
            }
        }
        super.execute();
    }

    protected File getStagingDirectory(MavenProject currentProject, List<MavenProject> reactorProjects, File usersStagingDirectory) {
        File buildDirectory;
        if (usersStagingDirectory != null) {
            this.getLog().debug((CharSequence)"stagingDirectory specified by the user.");
            return usersStagingDirectory;
        }
        this.getLog().debug((CharSequence)"stagingDirectory NOT specified by the user.");
        MavenProject topLevelProject = this.getTopLevelProject(reactorProjects);
        if (topLevelProject == null) {
            this.getLog().debug((CharSequence)"No top level project found in the reactor, using the current project.");
            buildDirectory = new File(currentProject.getBuild().getDirectory());
        } else {
            this.getLog().debug((CharSequence)"Using the top level project found in the reactor.");
            buildDirectory = new File(topLevelProject.getBuild().getDirectory());
        }
        return new File(buildDirectory, DEFAULT_STAGING_DIRECTORY);
    }

    protected MavenProject getTopLevelProject(List<MavenProject> reactorProjects) {
        MavenProject topLevelProject = null;
        if (reactorProjects != null) {
            for (MavenProject reactorProject : reactorProjects) {
                if (!reactorProject.isExecutionRoot()) continue;
                topLevelProject = reactorProject;
            }
        }
        return topLevelProject;
    }

    protected static String getStructure(MavenProject project, boolean ignoreMissingSiteUrl) throws MojoFailureException {
        if (project.getDistributionManagement() == null) {
            String hierarchy = project.getArtifactId();
            for (MavenProject parent = project.getParent(); parent != null; parent = parent.getParent()) {
                hierarchy = parent.getArtifactId() + "/" + hierarchy;
            }
            return hierarchy;
        }
        Site site = project.getDistributionManagement().getSite();
        if (site == null) {
            if (!ignoreMissingSiteUrl) {
                throw new MojoFailureException("Missing site information in the distribution management element in the project: '" + project.getName() + "'.");
            }
            return null;
        }
        if (StringUtils.isEmpty((String)site.getUrl())) {
            if (!ignoreMissingSiteUrl) {
                throw new MojoFailureException("The URL in the site is missing in the project descriptor.");
            }
            return null;
        }
        Repository repository = new Repository(site.getId(), site.getUrl());
        StringBuffer hierarchy = new StringBuffer(1024);
        hierarchy.append(repository.getHost());
        if (!StringUtils.isEmpty((String)repository.getBasedir())) {
            if (!repository.getBasedir().startsWith("/")) {
                hierarchy.append('/');
            }
            hierarchy.append(repository.getBasedir());
        }
        return hierarchy.toString().replaceAll("[\\:\\?\\*]", "");
    }
}

