/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class ExportMojo
extends AbstractScmMojo {
    private String scmVersionType;
    private String scmVersion;
    private String exportDirectory;

    public void execute() throws MojoExecutionException {
        this.export();
    }

    protected String getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(String exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    protected void export() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            try {
                if (StringUtils.isNotEmpty((String)this.getExportDirectory())) {
                    File f = new File(this.getExportDirectory());
                    if (f.exists()) {
                        this.getLog().info((CharSequence)("Removing " + this.getExportDirectory()));
                        FileUtils.deleteDirectory((String)this.getExportDirectory());
                    }
                    f.mkdirs();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot remove " + this.getExportDirectory());
            }
            ExportScmResult result = this.getScmManager().export(repository, new ScmFileSet(new File(this.getExportDirectory()).getAbsoluteFile()), this.getScmVersion(this.scmVersionType, this.scmVersion), this.getExportDirectory());
            this.checkResult((ScmResult)result);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run export command : ", (Exception)((Object)e));
        }
    }
}

