/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.plugin.CheckoutMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class BootstrapMojo
extends CheckoutMojo {
    private String goals;
    private String profiles;
    private String goalsDirectory;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getCheckoutResult() != null) {
            this.runGoals(this.getCheckoutResult().getRelativePathProjectDirectory());
        }
    }

    private void runGoals(String relativePathProjectDirectory) throws MojoExecutionException {
        Commandline cl = new Commandline();
        try {
            cl.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't add system environment variables to mvn command line.", e);
        }
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cl.setExecutable("mvn");
        cl.setWorkingDirectory(this.determineWorkingDirectoryPath(this.getCheckoutDirectory(), relativePathProjectDirectory, this.goalsDirectory));
        if (this.goals != null) {
            String[] tokens = StringUtils.split((String)this.goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArg().setValue(tokens[i]);
            }
        }
        if (!StringUtils.isEmpty((String)this.profiles)) {
            cl.createArg().setValue("-P" + this.profiles);
        }
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of mvn execution is: '" + result + "'. Release failed.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    protected String determineWorkingDirectoryPath(File checkoutDirectory, String relativePathProjectDirectory, String goalsDirectory) {
        File projectDirectory = StringUtils.isNotEmpty((String)relativePathProjectDirectory) ? new File(checkoutDirectory, relativePathProjectDirectory) : checkoutDirectory;
        if (StringUtils.isEmpty((String)goalsDirectory)) {
            return projectDirectory.getPath();
        }
        return new File(projectDirectory, goalsDirectory).getPath();
    }
}

