/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ProjectInfoReportUtils {
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"});

    public static String getInputStream(URL url, Settings settings) throws IOException {
        return ProjectInfoReportUtils.getInputStream(url, settings, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInputStream(URL url, Settings settings, String encoding) throws IOException {
        Proxy proxy;
        String scheme = url.getProtocol();
        if (!"file".equals(scheme) && (proxy = settings.getActiveProxy()) != null) {
            scheme = "http".equals(scheme) || "https".equals(scheme) ? "http." : ("ftp".equals(scheme) ? "ftp." : "");
            String host = proxy.getHost();
            if (!StringUtils.isEmpty((String)host)) {
                String userName;
                Properties p = System.getProperties();
                p.setProperty(scheme + "proxySet", "true");
                p.setProperty(scheme + "proxyHost", host);
                p.setProperty(scheme + "proxyPort", String.valueOf(proxy.getPort()));
                if (!StringUtils.isEmpty((String)proxy.getNonProxyHosts())) {
                    p.setProperty(scheme + "nonProxyHosts", proxy.getNonProxyHosts());
                }
                if (!StringUtils.isEmpty((String)(userName = proxy.getUsername()))) {
                    final String pwd = StringUtils.isEmpty((String)proxy.getPassword()) ? "" : proxy.getPassword();
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, pwd.toCharArray());
                        }
                    });
                }
            }
        }
        InputStream in = null;
        try {
            String string;
            in = url.openStream();
            if (encoding == null) {
                string = IOUtil.toString((InputStream)in, (String)"ISO-8859-1");
                return string;
            }
            string = IOUtil.toString((InputStream)in, (String)encoding);
            return string;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public static String getArtifactUrl(ArtifactFactory factory, Artifact artifact, MavenProjectBuilder mavenProjectBuilder, List remoteRepositories, ArtifactRepository localRepository) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
        if (!"pom".equals(copyArtifact.getType())) {
            copyArtifact = factory.createProjectArtifact(copyArtifact.getGroupId(), copyArtifact.getArtifactId(), copyArtifact.getVersion(), copyArtifact.getScope());
        }
        try {
            MavenProject pluginProject = mavenProjectBuilder.buildFromRepository(copyArtifact, remoteRepositories, localRepository);
            if (ProjectInfoReportUtils.isArtifactUrlValid(pluginProject.getUrl())) {
                return pluginProject.getUrl();
            }
            return null;
        }
        catch (ProjectBuildingException e) {
            return null;
        }
    }

    public static String getArtifactIdCell(String artifactId, String link) {
        if (StringUtils.isEmpty((String)link)) {
            return artifactId;
        }
        return "{" + artifactId + "," + link + "}";
    }

    public static boolean isArtifactUrlValid(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        return URL_VALIDATOR.isValid(url);
    }
}

