/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.myeclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class MyEclipseMetadataWriter
extends AbstractEclipseWriter {
    private static final String MYECLIPSE_MYMETADATA_FILENAME = ".mymetadata";
    private static final String MYECLIPSE_METADATA_PROJECT = "project-module";
    private static final String MYECLIPSE_METADATA_PROJECT_TYPE = "type";
    private static final String MYECLIPSE_METADATA_PROJECT_NAME = "name";
    private static final String MYECLIPSE_METADATA_PROJECT_ID = "id";
    private static final String MYECLIPSE_METADATA_PROJECT_CONTEXT_ROOT = "context-root";
    private static final String MYECLIPSE_METADATA_PROJECT_J2EE_SPEC = "j2ee-spec";
    private static final String MYECLIPSE_METADATA_PROJECT_ARCHIVE = "archive";
    private static final String MYECLIPSE_METADATA_PROJECT_TYPE_WAR = "WEB";
    private static final String MYECLIPSE_METADATA_PROJECT_TYPE_EAR = "EAR";
    private static final String MYECLIPSE_METADATA_PROJECT_TYPE_EJB = "EJB";
    private static final String MYECLIPSE_METADATA_PROJECT_ATTRIBUTES = "attributes";
    private static final String MYECLIPSE_METADATA_PROJECT_ATTRIBUTE = "attribute";

    public void write() throws MojoExecutionException {
        FileWriter w;
        String packaging = this.config.getProject().getPackaging();
        if (!("ear".equalsIgnoreCase(packaging) || "war".equalsIgnoreCase(packaging) || "ejb".equalsIgnoreCase(packaging))) {
            return;
        }
        try {
            w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), MYECLIPSE_MYMETADATA_FILENAME));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
        writer.startElement(MYECLIPSE_METADATA_PROJECT);
        writer.addAttribute(MYECLIPSE_METADATA_PROJECT_TYPE, this.getMyEclipseProjectType(packaging));
        writer.addAttribute(MYECLIPSE_METADATA_PROJECT_NAME, this.config.getEclipseProjectName());
        writer.addAttribute(MYECLIPSE_METADATA_PROJECT_ID, this.config.getEclipseProjectName());
        if ("war".equalsIgnoreCase(packaging)) {
            String warContextRoot = IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warContextRoot", "/" + this.config.getProject().getArtifactId());
            writer.addAttribute(MYECLIPSE_METADATA_PROJECT_CONTEXT_ROOT, warContextRoot);
            writer.addAttribute(MYECLIPSE_METADATA_PROJECT_J2EE_SPEC, this.getJeeVersion());
            writer.addAttribute(MYECLIPSE_METADATA_PROJECT_ARCHIVE, this.config.getEclipseProjectName() + ".war");
        }
        if ("ear".equalsIgnoreCase(packaging)) {
            writer.addAttribute(MYECLIPSE_METADATA_PROJECT_ARCHIVE, this.config.getEclipseProjectName() + ".ear");
        }
        writer.startElement(MYECLIPSE_METADATA_PROJECT_ATTRIBUTES);
        if ("war".equalsIgnoreCase(packaging)) {
            writer.startElement(MYECLIPSE_METADATA_PROJECT_ATTRIBUTE);
            writer.addAttribute(MYECLIPSE_METADATA_PROJECT_NAME, "webrootdir");
            writer.addAttribute("value", "src/main/webapp");
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private String getMyEclipseProjectType(String packaging) {
        if ("war".equalsIgnoreCase(packaging)) {
            return MYECLIPSE_METADATA_PROJECT_TYPE_WAR;
        }
        if ("ear".equalsIgnoreCase(packaging)) {
            return MYECLIPSE_METADATA_PROJECT_TYPE_EAR;
        }
        if ("ejb".equalsIgnoreCase(packaging)) {
            return MYECLIPSE_METADATA_PROJECT_TYPE_EJB;
        }
        return null;
    }

    private String getJeeVersion() {
        String jeeVersion = JeeUtils.getJeeDescriptorFromServletVersion(JeeUtils.resolveServletVersion(this.config.getProject())).getJeeVersion();
        if (jeeVersion == null) {
            return "1.4";
        }
        return jeeVersion;
    }
}

