/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AddArtifactTask
implements ArchiverTask {
    public static final String[] DEFAULT_INCLUDES_ARRAY = new String[]{"**/*"};
    private int directoryMode = -1;
    private int fileMode = -1;
    private boolean unpack = false;
    private List includes;
    private List excludes;
    private final Artifact artifact;
    private MavenProject project;
    private MavenProject moduleProject;
    private Artifact moduleArtifact;
    private String outputDirectory;
    private String outputFileNameMapping;
    private final Logger logger;

    public AddArtifactTask(Artifact artifact, Logger logger) {
        this.artifact = artifact;
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        if (this.artifact.getFile() != null && archiver.getDestFile() != null && this.artifact.getFile().equals(archiver.getDestFile())) {
            File tempRoot = configSource.getTemporaryRootDirectory();
            File tempArtifactFile = new File(tempRoot, this.artifact.getFile().getName());
            this.logger.warn("Artifact: " + this.artifact.getId() + " references the same file as the assembly destination file. Moving it to a temporary location for inclusion.");
            try {
                FileUtils.copyFile((File)this.artifact.getFile(), (File)tempArtifactFile);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error moving artifact file: '" + this.artifact.getFile() + "' to temporary location: " + tempArtifactFile + ". Reason: " + e.getMessage(), e);
            }
            this.artifact.setFile(tempArtifactFile);
        }
        String destDirectory = this.outputDirectory;
        destDirectory = AssemblyFormatUtils.getOutputDirectory(destDirectory, configSource.getProject(), this.moduleProject, this.project, configSource.getFinalName(), configSource);
        if (this.unpack) {
            boolean fileModeSet;
            int oldFileMode;
            block21: {
                Object[] includesArray;
                String outputLocation = destDirectory;
                if (outputLocation.length() > 0 && !outputLocation.endsWith("/")) {
                    outputLocation = outputLocation + "/";
                }
                if ((includesArray = TypeConversionUtils.toStringArray(this.includes)) == null) {
                    includesArray = DEFAULT_INCLUDES_ARRAY;
                }
                Object[] excludesArray = TypeConversionUtils.toStringArray(this.excludes);
                int oldDirMode = archiver.getOverrideDirectoryMode();
                oldFileMode = archiver.getOverrideFileMode();
                this.logger.debug("Unpacking artifact: " + this.artifact.getId() + " to assembly location: " + outputLocation + ".");
                fileModeSet = false;
                boolean dirModeSet = false;
                try {
                    block20: {
                        try {
                            File artifactFile;
                            if (this.fileMode != -1) {
                                archiver.setFileMode(this.fileMode);
                                fileModeSet = true;
                            }
                            if (this.directoryMode != -1) {
                                archiver.setDirectoryMode(this.directoryMode);
                                dirModeSet = true;
                            }
                            if ((artifactFile = this.artifact.getFile()) == null) {
                                this.logger.warn("Skipping artifact: " + this.artifact.getId() + "; it does not have an associated file or directory.");
                                break block20;
                            }
                            if (artifactFile.isDirectory()) {
                                this.logger.debug("Adding artifact directory contents for: " + this.artifact + " to: " + outputLocation);
                                archiver.addDirectory(artifactFile, outputLocation, (String[])includesArray, (String[])excludesArray);
                            } else {
                                this.logger.debug("Unpacking artifact contents for: " + this.artifact + " to: " + outputLocation);
                                this.logger.debug("includes:\n" + StringUtils.join((Object[])includesArray, (String)"\n") + "\n");
                                this.logger.debug("excludes:\n" + (excludesArray == null ? "none" : StringUtils.join((Object[])excludesArray, (String)"\n")) + "\n");
                                archiver.addArchivedFileSet(artifactFile, outputLocation, (String[])includesArray, (String[])excludesArray);
                            }
                        }
                        catch (ArchiverException e) {
                            throw new ArchiveCreationException("Error adding file-set for '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
                        }
                    }
                    Object var13_17 = null;
                    if (!dirModeSet) break block21;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (dirModeSet) {
                        archiver.setDirectoryMode(oldDirMode);
                    }
                    if (!fileModeSet) throw throwable;
                    archiver.setFileMode(oldFileMode);
                    throw throwable;
                }
                archiver.setDirectoryMode(oldDirMode);
            }
            if (!fileModeSet) return;
            archiver.setFileMode(oldFileMode);
            return;
        }
        String fileNameMapping = AssemblyFormatUtils.evaluateFileNameMapping(this.outputFileNameMapping, this.artifact, configSource.getProject(), this.moduleProject, this.moduleArtifact, this.project, configSource);
        String outputLocation = destDirectory + fileNameMapping;
        try {
            File artifactFile = this.artifact.getFile();
            this.logger.debug("Adding artifact: " + this.artifact.getId() + " with file: " + artifactFile + " to assembly location: " + outputLocation + ".");
            if (this.fileMode != -1) {
                archiver.addFile(artifactFile, outputLocation, this.fileMode);
                return;
            }
            archiver.addFile(artifactFile, outputLocation);
            return;
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
        }
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public void setOutputDirectory(String outputDirectory, String defaultOutputDirectory) {
        this.setOutputDirectory(outputDirectory == null ? defaultOutputDirectory : outputDirectory);
    }

    public void setFileNameMapping(String outputFileNameMapping, String defaultOutputFileNameMapping) {
        this.setFileNameMapping(outputFileNameMapping == null ? defaultOutputFileNameMapping : outputFileNameMapping);
    }

    public MavenProject getModuleProject() {
        return this.moduleProject;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public Artifact getModuleArtifact() {
        return this.moduleArtifact;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }
}

