/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.FacingUtil;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShooting;

public class LinkGunShooting
extends AbstractWeaponShooting
implements WeaponShooting {
    protected static final int SHIELD_GUN_FACING_ANGLE = 90;
    protected static final int LINK_GUN_SEC_MAX_RANGE = 1150;
    protected static final WeaponPref LINK_GUN_SECONDARY = new WeaponPref(ItemType.LINK_GUN, false);
    protected static final WeaponPref LINK_GUN_PRIMARY = new WeaponPref(ItemType.LINK_GUN, true);

    public LinkGunShooting(UT2004Bot<?, ?, ?> bot, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(bot, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        boolean closeEnough;
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShoot();
            return;
        }
        if (!(this.target instanceof Player)) {
            this.shoot.shoot(this.weaponPref, this.target);
            return;
        }
        Player player = (Player)this.target;
        if (!player.isVisible()) {
            this.shoot.stopShoot();
            return;
        }
        if (this.info.isFriend(player)) {
            this.shootFriend(player);
            return;
        }
        if (!this.info.isFacing(this.target).booleanValue()) {
            this.shoot.stopShoot();
            return;
        }
        boolean targetFacing = FacingUtil.isFacing(player, (ILocated)this.agent, 90.0);
        boolean targetShieldGun = player.getWeapon().contains("ShieldGun");
        boolean targetShielded = player.getFiring() == 2;
        boolean targetCanDeflect = targetShieldGun && targetFacing && targetShielded;
        boolean bl = closeEnough = this.info.getLocation().getDistance(player.getLocation()) < 1150.0;
        if (targetCanDeflect && closeEnough) {
            this.shoot.shoot(LINK_GUN_SECONDARY, this.target);
        } else if (!targetCanDeflect && !closeEnough) {
            this.shoot.shoot(LINK_GUN_PRIMARY, this.target);
        } else if (!targetCanDeflect) {
            this.shoot.shoot(this.weaponPref, this.target);
        } else {
            this.shoot.stopShoot();
        }
    }

    protected void shootFriend(Player player) {
        if (this.canAssist(player) && this.info.isFacing((ILocated)player).booleanValue()) {
            this.shoot.shoot(LINK_GUN_SECONDARY, (ILocated)player);
        } else {
            this.shoot.stopShoot();
        }
    }

    protected boolean canAssist(Player player) {
        if (player == null) {
            return false;
        }
        boolean friend = this.info.isFriend(player);
        boolean hasLinkGun = player.getWeapon() != null && player.getWeapon().contains("LinkGun");
        boolean closeEnough = this.info.getLocation().getDistance(player.getLocation()) < 1150.0;
        return friend && hasLinkGun && closeEnough;
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return LINK_GUN_PRIMARY;
    }
}

