/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTestController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShootingParameters;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponryShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.AssaultRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.BioRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.FlakCannonShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LigthningGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LinkGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.MinigunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.RocketLauncherShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShieldGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShockRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.SniperRifleShooting;

public class WeaponShootingTestController
extends UT2004BotTestController<UT2004Bot> {
    protected WeaponryShooting weaponShooting;
    protected Projectiles projectiles;
    protected WeaponShootingParameters parameters;
    protected ItemType weapon;
    protected ItemType ammo;
    protected boolean primary;
    protected List<NavPoint> firingRange;
    protected TabooSet<NavPoint> visited;
    protected Heatup waitAtLocation;
    protected Heatup testDuration;
    protected NavPoint currentStation;

    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.projectiles = new Projectiles(bot, this.info);
        this.weaponShooting = new WeaponryShooting(bot, this.info, this.weaponry, this.weaponPrefs, this.shoot);
        this.initializeWeaponShootings();
    }

    protected void initializeWeaponShootings() {
        this.weaponShooting.addWeaponShooting((WeaponShooting)new LinkGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ShockRifleShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new MinigunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new FlakCannonShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ShieldGunShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles, this.senses));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new BioRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new AssaultRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new RocketLauncherShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new LigthningGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new SniperRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
    }

    public void finishControllerInitialization() {
        super.finishControllerInitialization();
        this.navigation.setFocus((ILocated)this.weaponShooting.getFocus());
    }

    public void prepareBot(UT2004Bot bot) {
        this.parameters = (WeaponShootingParameters)bot.getParams();
        this.weapon = this.parameters.getWeapon();
        this.ammo = this.parameters.getAmmo();
        this.primary = this.parameters.isPrimary();
        this.visited = new TabooSet(bot);
        this.waitAtLocation = new Heatup(this.parameters.getWaitAtLocation(), TimeUnit.SECONDS);
        this.testDuration = new Heatup(this.parameters.getTestDuration(), TimeUnit.MINUTES);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setTeam(this.parameters.getTeam());
    }

    public void beforeFirstLogic() {
        this.firingRange = new ArrayList<NavPoint>();
        for (String id : this.parameters.getFiringRange()) {
            this.firingRange.add((NavPoint)this.world.get((WorldObjectId)UnrealId.get((String)id), NavPoint.class));
        }
        this.currentStation = this.firingRange.get(0);
        this.weaponPrefs.addGeneralPref(this.weapon, this.primary);
        this.testDuration.heat();
    }

    public void logic() throws PogamutException {
        if (this.weapon.getCategory() == ItemType.Category.SHIELD && this.primary) {
            this.logicShieldPrimary();
            return;
        }
        if (this.weapon.getGroup() == ItemType.Group.LINK_GUN && !this.primary) {
            this.logicLinkGunSecondary();
            return;
        }
        if (this.checkTestComplete()) {
            return;
        }
        if (this.weapon.getCategory() == ItemType.Category.SHIELD && !this.primary) {
            this.logicShieldSecondary();
            return;
        }
        this.logicOther();
    }

    protected void logicOther() {
        Player player = this.players.getNearestVisibleEnemy();
        if (player != null) {
            this.weaponShooting.shoot((ILocated)player);
        }
        if (this.navigation.isNavigating()) {
            return;
        }
        if (!this.weaponry.hasAmmoForWeapon(this.weapon)) {
            Map spawned = this.items.getSpawnedItems(this.ammo);
            Item closest = (Item)DistanceUtils.getNearest(spawned.values(), (ILocated)this.bot);
            this.navigation.navigate((ILocated)closest);
            return;
        }
        if (!this.weaponry.hasWeapon(this.weapon)) {
            Map spawned = this.items.getSpawnedItems(this.weapon);
            Item closest = (Item)DistanceUtils.getNearest(spawned.values(), (ILocated)this.bot);
            if (closest == null) {
                this.setFailure("Weapon to test is not available on this map");
            } else {
                this.navigation.navigate((ILocated)closest.getLocation());
            }
            return;
        }
        if (!this.info.atLocation((ILocated)this.currentStation)) {
            this.navigation.navigate((ILocated)this.currentStation);
            this.waitAtLocation.heat();
            return;
        }
        if (this.waitAtLocation.isCool()) {
            this.visited.add((Object)this.currentStation);
            this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            if (this.currentStation == null) {
                this.visited.clear();
                this.currentStation = (NavPoint)MyCollections.getRandom((Collection)this.visited.filter(this.firingRange));
            }
            return;
        }
        if (player != null) {
            this.move.turnTo(player);
        } else if (this.players.canSeeEnemies()) {
            this.move.turnTo(this.players.getNearestVisibleEnemy());
        } else {
            this.move.turnHorizontal(30);
        }
    }

    private void logicLinkGunSecondary() {
        if (this.navigation.isNavigating()) {
            return;
        }
        if (!this.weaponry.hasWeapon(this.weapon)) {
            Map spawned = this.items.getSpawnedItems(this.weapon);
            Item closest = (Item)DistanceUtils.getNearest(spawned.values(), (ILocated)this.bot);
            if (closest == null) {
                this.setFailure("Weapon to test is not available on this map");
            } else {
                this.navigation.navigate((ILocated)closest.getLocation());
            }
            return;
        }
        if (!this.weaponry.hasAmmoForWeapon(this.weapon)) {
            Map spawned = this.items.getSpawnedItems(this.ammo);
            Item closest = (Item)DistanceUtils.getNearest(spawned.values(), (ILocated)this.bot);
            this.navigation.navigate((ILocated)closest);
            return;
        }
        List linkGunPlayers = MyCollections.getFiltered(this.players.getFriends().values(), (IFilter)new IFilter<Player>(){

            public boolean isAccepted(Player object) {
                return object.getWeapon() != null && object.getWeapon().contains("LinkGun") && object.getName().compareTo(WeaponShootingTestController.this.info.getName()) < 0;
            }
        });
        Player closestLinkGunPlayer = (Player)DistanceUtils.getNearest((Collection)linkGunPlayers, (ILocated)this.bot);
        Player closestEnemy = this.players.getNearestVisibleEnemy();
        if (closestLinkGunPlayer != null && closestLinkGunPlayer.isVisible()) {
            this.weaponShooting.shoot((ILocated)closestLinkGunPlayer);
            this.navigation.navigate(closestLinkGunPlayer);
            return;
        }
        if (closestEnemy != null) {
            this.weaponShooting.shoot((ILocated)closestEnemy);
        }
        if (!this.info.atLocation((ILocated)this.currentStation)) {
            this.navigation.navigate((ILocated)this.currentStation);
            this.waitAtLocation.heat();
            return;
        }
        if (this.waitAtLocation.isCool()) {
            this.visited.add((Object)this.currentStation);
            this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            if (this.currentStation == null) {
                this.visited.clear();
                this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            }
            return;
        }
        if (closestLinkGunPlayer != null) {
            this.move.turnTo(closestLinkGunPlayer);
        } else if (closestEnemy != null) {
            this.move.turnTo(closestEnemy);
        } else {
            this.move.turnHorizontal(30);
        }
    }

    private void logicShieldSecondary() {
        Player player = this.players.getNearestVisibleEnemy();
        if (player != null) {
            this.weaponShooting.shoot((ILocated)player);
        }
        if (!this.info.atLocation((ILocated)this.currentStation)) {
            this.navigation.navigate((ILocated)this.currentStation);
            this.waitAtLocation.heat();
            return;
        }
        if (this.waitAtLocation.isCool()) {
            this.visited.add((Object)this.currentStation);
            this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            if (this.currentStation == null) {
                this.visited.clear();
                this.currentStation = (NavPoint)MyCollections.getRandom((Collection)this.visited.filter(this.firingRange));
            }
            return;
        }
        this.move.turnHorizontal(30);
    }

    private void logicShieldPrimary() {
        Player player = this.players.getNearestVisibleEnemy();
        if (player != null) {
            this.weaponShooting.shoot((ILocated)player);
        }
        if (this.navigation.isNavigating()) {
            return;
        }
        if (player != null) {
            this.navigation.navigate(player);
            return;
        }
        if (!this.info.atLocation((ILocated)this.currentStation)) {
            this.navigation.navigate((ILocated)this.currentStation);
            this.waitAtLocation.heat();
            return;
        }
        if (this.waitAtLocation.isCool()) {
            this.visited.add((Object)this.currentStation);
            this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            if (this.currentStation == null) {
                this.visited.clear();
                this.currentStation = (NavPoint)MyCollections.getRandom((Collection)this.visited.filter(this.firingRange));
            }
            return;
        }
        this.move.turnHorizontal(30);
    }

    protected boolean checkTestComplete() {
        if (this.testDuration.isHot()) {
            return false;
        }
        if (this.weapon.getCategory() == ItemType.Category.SHIELD && !this.primary) {
            return true;
        }
        if (this.info.getKills() == 0 && !this.info.getName().contains("Support")) {
            this.setFailure(String.format("Test ran for %s minutes without any kills.", this.parameters.getTestDuration()));
            return true;
        }
        this.setSuccess(String.format("Test ran for %s minutes without errors. Bot killed %s people.", this.parameters.getTestDuration(), this.info.getKills()));
        return true;
    }
}

