package nl.tudelft.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

/**
 * Copies from {@link AgentInfo#isFacing(ILocated)}
 * 
 * @author mpkorstanje
 *
 */
public class FacingUtil {

	/**
	 * What angle is considered to be maximum facing angle by default (in
	 * degrees).
	 */
	public static final double IS_FACING_ANGLE = 6;

	/**
	 * Tells if the player is currently facing input location.
	 * 
	 * @param player
	 *            the player:
	 * 
	 * @param location
	 *            input location.
	 * @return True, if the bot is facing input location.
	 */
	public static boolean isFacing(Player player, ILocated location) {
		return isFacing(player, location, IS_FACING_ANGLE);
	}

	/**
	 * Tells if the player is currently facing input location.
	 * 
	 * @param player
	 *            the player:
	 * @param location
	 *            input location.
	 * @param angle
	 *            specifies maximum angle (in degrees) that will be still
	 *            considered as facing angle.
	 * @return True, if the angle between agent facing vector and input location
	 *         is smaller or equal to input angle.
	 */
	public static boolean isFacing(Player player, ILocated location, double angle) {
		if (player == null || location == null || player.getRotation() == null)
			return false;
		Location directionVector = location.getLocation().sub(player.getLocation()).getNormalized();
		Location agentFaceVector = player.getRotation().toLocation().getNormalized();

		if (Math.acos(directionVector.dot(agentFaceVector)) <= Math.toRadians(angle))
			return true;

		return false;
	}

}
